/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.HttpMessage;
import ice.net.HttpResponse;
import java.net.ProtocolException;
import java.util.StringTokenizer;

public class HttpParser {
    public static void parseHeader(String header, HttpMessage httpMessage) throws IllegalArgumentException, ProtocolException {
        String _fieldValue;
        String _fieldName;
        if (header == null) {
            throw new IllegalArgumentException("header is null");
        }
        if (httpMessage == null) {
            throw new IllegalArgumentException("httpMessage is null");
        }
        int _index = header.indexOf(":");
        if (_index != -1) {
            _fieldName = header.substring(0, _index).trim();
            _fieldValue = header.substring(_index + 1).trim();
            if (_fieldValue.length() == 0) {
                _fieldValue = "unknown/unknown";
            }
        } else {
            throw new ProtocolException("Invalid header: " + header);
        }
        httpMessage.putHeader(_fieldName, _fieldValue);
    }

    public static HttpResponse parseStatusLine(String statusLine) throws IllegalArgumentException, ProtocolException {
        if (statusLine == null) {
            throw new IllegalArgumentException("statusLine is null");
        }
        StringTokenizer _tokens = new StringTokenizer(statusLine);
        int _count = _tokens.countTokens();
        if (_count-- != 0) {
            String _version = HttpParser.parseVersion(_tokens.nextToken());
            if (_count-- != 0) {
                int _statusCode = HttpParser.parseStatusCode(_tokens.nextToken());
                StringBuffer _reasonPhrase = new StringBuffer();
                while (_count-- != 0) {
                    _reasonPhrase.append(_tokens.nextToken());
                    if (_count == 0) continue;
                    _reasonPhrase.append(" ");
                }
                return new HttpResponse(_version, _statusCode, _reasonPhrase.toString());
            }
            throw new ProtocolException("Invalid status line; missing status code: " + statusLine);
        }
        throw new ProtocolException("Invalid status line: empty");
    }

    private static int parseStatusCode(String statusCode) throws ProtocolException {
        if (statusCode.length() != 3) {
            throw new ProtocolException("Invalid status code: " + statusCode);
        }
        int _statusCode = 0;
        for (int i = 0; i < 3; ++i) {
            char _char = statusCode.charAt(i);
            if (!Character.isDigit(_char)) {
                throw new ProtocolException("Invalid status code: " + statusCode);
            }
            _statusCode = _statusCode * 10 + Integer.parseInt(new Character(_char).toString());
        }
        return _statusCode;
    }

    private static String parseVersion(String version) throws ProtocolException {
        if (!version.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid version: " + version);
        }
        int _index = 5;
        int _length = version.length();
        while (Character.isDigit(version.charAt(_index))) {
            if (++_index != _length) continue;
            throw new ProtocolException("Invalid version: " + version);
        }
        if (version.charAt(_index++) != '.') {
            throw new ProtocolException("Invalid version: " + version);
        }
        while (Character.isDigit(version.charAt(_index))) {
            if (++_index != _length) continue;
            return version;
        }
        throw new ProtocolException("Invalid version: " + version);
    }
}

