/*
 * Decompiled with CFR 0.152.
 */
package ice.authentication.digest;

import ice.authentication.AbstractAuthentication;
import ice.authentication.Authentication;
import ice.net.MyDigest;
import java.net.URL;

public class DigestAuthentication
extends AbstractAuthentication
implements Authentication {
    private static boolean digestEnabled;
    private String method;
    private String nonce;

    public DigestAuthentication(String realm, URL requestUri) throws IllegalArgumentException {
        super(requestUri);
        this.setType(1);
        if (realm == null) {
            throw new IllegalArgumentException("realm is null");
        }
        if (realm.trim().length() == 0) {
            throw new IllegalArgumentException("realm is empty");
        }
        this.setRealm(realm);
    }

    public String getCredentials() {
        if (!digestEnabled) {
            return "Digest disabled";
        }
        String _A1 = new String(this.userName + ":" + this.realm + ":" + this.password);
        String _A2 = new String(this.method + ":" + this.requestUri.getFile());
        MyDigest _d1 = null;
        MyDigest _d2 = null;
        MyDigest _d3 = null;
        try {
            Class<?> _digestClass = Class.forName("ice.net.MyMessageDigest");
            _d1 = ((MyDigest)_digestClass.newInstance()).getInstance("MD5");
            _d2 = ((MyDigest)_digestClass.newInstance()).getInstance("MD5");
            _d3 = ((MyDigest)_digestClass.newInstance()).getInstance("MD5");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _d1.update(_A1.getBytes());
        _d1.digest();
        _A1 = this.extractDigestAsHex(((Object)_d1).toString());
        _d2.update(_A2.getBytes());
        _d2.digest();
        _A2 = this.extractDigestAsHex(((Object)_d2).toString());
        _d3.update(new String(_A1 + ":" + this.nonce + ":" + _A2).getBytes());
        _d3.digest();
        return new String("Digest realm=\"" + this.realm + "\"," + "username=\"" + this.userName + "\"," + "uri=\"" + this.requestUri.getFile() + "\"," + "nonce=\"" + this.nonce + "\"," + "response=\"" + this.extractDigestAsHex(((Object)_d3).toString()) + "\"");
    }

    public String getMethod() {
        return this.method;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getScheme() {
        return "Digest";
    }

    public boolean isVolatile() {
        return false;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    private String extractDigestAsHex(String digest) {
        return digest.substring(digest.indexOf(60) + 1, digest.indexOf(62));
    }

    static {
        try {
            ((MyDigest)Class.forName("ice.net.MyMessageDigest").newInstance()).getInstance("MD5");
            digestEnabled = true;
        }
        catch (ClassNotFoundException exception) {
            digestEnabled = false;
        }
        catch (InstantiationException exception) {
            digestEnabled = false;
        }
        catch (IllegalAccessException exception) {
            digestEnabled = false;
        }
        catch (Throwable throwable) {
            digestEnabled = false;
        }
    }
}

