/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.token;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.STError;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.token.Token;
import com.lotus.sametime.token.TokenEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class TokenImpl
extends STCompImpl
implements ChannelListener,
LoginListener,
ServiceListener {
    public static final int GET_TOKEN_PROT_VERSION = 0;
    public static final short MSG_GET_TOKEN_REQUEST = 0;
    public static final short MSG_GET_TOKEN_RESPONSE = 1;
    private Channel m_channel;
    private ChannelService m_channelService;
    private boolean m_tokenRequested = false;
    private CommunityService m_comm;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.token");

    public TokenImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.token.TokenComp", sTSession);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_comm) {
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
            if (this.m_comm.isLoggedIn()) {
                this.m_comm.senseService(-2147483603);
            }
        }
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (this.m_channelService == null && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
        }
        if (null == this.m_comm && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
            if (this.m_comm.isLoggedIn()) {
                this.m_comm.senseService(-2147483603);
            }
        }
    }

    public void getToken() {
        if (this.m_tokenRequested) {
            return;
        }
        if (this.m_channel == null) {
            this.m_channel = this.m_channelService.createChannel(-2147483603, 36, 0, EncLevel.ENC_LEVEL_RC2_40, null, null);
            this.m_channel.addChannelListener(this);
            this.m_channel.open();
        }
        if (this.m_channel.isOpen()) {
            this.sendGetTokenRequest();
        }
    }

    public void channelOpened(ChannelEvent channelEvent) {
        this.sendGetTokenRequest();
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Object object;
        if (channelEvent.getMessageType() != 1) {
            return;
        }
        int n = 0;
        String string = null;
        String string2 = null;
        try {
            object = new NdrInputStream(channelEvent.getData());
            n = ((DataInputStream)object).readInt();
            string = ((DataInputStream)object).readUTF();
            try {
                string2 = ((DataInputStream)object).readUTF();
            }
            catch (IOException iOException) {
                string2 = this.getDefaultLoginName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = null;
        if (string != null && STError.VpkSucceeded(n)) {
            Token token = new Token(string2, string);
            object = new TokenEvent((Object)this, -2147483647, token);
        } else {
            object = new TokenEvent((Object)this, -2147483645, n);
        }
        this.sendEvent((STEvent)object);
    }

    public void channelClosed(ChannelEvent channelEvent) {
        this.channelDestroyed(channelEvent);
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        TokenEvent tokenEvent = new TokenEvent((Object)this, -2147483645, channelEvent.getReason());
        this.sendEvent(tokenEvent);
        this.channelDestroyed(channelEvent);
    }

    private void channelDestroyed(ChannelEvent channelEvent) {
        this.m_tokenRequested = false;
        this.m_channel = null;
        if (channelEvent.getReason() == -2147483635) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelDestroyed", "TOKEN SERVICE IS UP");
            }
            this.m_comm.senseService(-2147483603);
        }
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (serviceEvent.getServiceType() == -2147483603) {
            TokenEvent tokenEvent = new TokenEvent(this, -2147483644);
            this.sendEvent(tokenEvent);
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.m_comm.senseService(-2147483603);
    }

    public void loggedOut(LoginEvent loginEvent) {
    }

    private void sendGetTokenRequest() {
        Debug.stAssert(this.m_channel != null && this.m_channel.isOpen());
        this.m_tokenRequested = true;
        this.m_channel.sendMsg((short)0, null, false);
    }

    private String getDefaultLoginName() {
        String string = "com.lotus.sametime.community.STBase";
        CommunityService communityService = (CommunityService)this.getSession().getCompApi(string);
        Login login = communityService.getLogin();
        STId sTId = login.getMyUserInstance().getId();
        return sTId.getId();
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof TokenEvent) {
            if (sTEvent.getId() == 1) {
                this.getToken();
            }
        } else {
            super.processSTEvent(sTEvent);
        }
    }
}

