/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.token;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.STError;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.token.Token;
import com.lotus.sametime.token.TokenEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class SATokenImpl
extends STCompImpl
implements ChannelListener {
    public static final int GET_TOKEN_PROT_VERSION = 1;
    public static final short MSG_GET_TOKEN_BY_USERID = 2;
    public static final short MSG_GET_TOKEN_RESPONSE = 1;
    private Channel m_channel;
    private ChannelService m_channelService;
    private Hashtable m_tokenRequests = new Hashtable();
    private Vector m_waitingUsers = new Vector();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.token");

    public SATokenImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.token.SATokenComp", sTSession);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (this.m_channelService == null && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
        }
    }

    public void generateTokenForUser(STUser sTUser) {
        if (this.m_channel == null) {
            this.m_channel = this.m_channelService.createChannel(-2147483603, 36, 1, EncLevel.ENC_LEVEL_RC2_40, null, null);
            this.m_channel.addChannelListener(this);
            this.m_channel.open();
        }
        if (this.m_channel.isOpen()) {
            this.sendGetTokenRequest(sTUser);
        } else {
            this.m_waitingUsers.addElement(sTUser);
        }
    }

    public void channelOpened(ChannelEvent channelEvent) {
        if (channelEvent.getChannel().getProtocolVersion() < 1) {
            this.sendFailed(-2147483136);
            return;
        }
        for (int i = 0; i < this.m_waitingUsers.size(); ++i) {
            STUser sTUser = (STUser)this.m_waitingUsers.elementAt(i);
            this.sendGetTokenRequest(sTUser);
        }
        this.m_waitingUsers.removeAllElements();
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Object object;
        if (channelEvent.getMessageType() != 1) {
            return;
        }
        int n = 0;
        String string = null;
        String string2 = null;
        try {
            object = new NdrInputStream(channelEvent.getData());
            n = ((DataInputStream)object).readInt();
            string = ((DataInputStream)object).readUTF();
            string2 = ((DataInputStream)object).readUTF();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        STUser sTUser = (STUser)this.m_tokenRequests.remove(string2);
        if (string != null && STError.VpkSucceeded(n)) {
            Token token = new Token(string2, string);
            object = new TokenEvent((Object)this, -2147483646, sTUser, token);
        } else {
            object = new TokenEvent((Object)this, -2147483645, sTUser, n);
        }
        this.sendEvent((STEvent)object);
        if (this.m_tokenRequests.isEmpty()) {
            this.m_channel.removeChannelListener(this);
            this.m_channel.close(0, null);
            this.m_channel = null;
        }
    }

    public void channelClosed(ChannelEvent channelEvent) {
        this.m_channel = null;
        this.m_tokenRequests.clear();
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        this.sendFailed(channelEvent.getReason());
    }

    private void sendFailed(int n) {
        Enumeration enumeration = this.m_waitingUsers.elements();
        while (enumeration.hasMoreElements()) {
            TokenEvent tokenEvent = new TokenEvent((Object)this, -2147483645, (STUser)enumeration.nextElement(), n);
            this.sendEvent(tokenEvent);
        }
        this.m_waitingUsers.removeAllElements();
        this.m_channel = null;
    }

    private void sendGetTokenRequest(STUser sTUser) {
        Debug.stAssert(this.m_channel != null && this.m_channel.isOpen());
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeUTF(sTUser.getId().getId());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.m_tokenRequests.put(sTUser.getId().getId(), sTUser);
        this.m_channel.sendMsg((short)2, ndrOutputStream.toByteArray(), false);
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof TokenEvent) {
            if (sTEvent.getId() == 2) {
                this.generateTokenForUser(((TokenEvent)sTEvent).getUser());
            }
        } else {
            super.processSTEvent(sTEvent);
        }
    }
}

