/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlaceMemberImpl;
import com.lotus.sametime.places.PlaceMemberListener;
import com.lotus.sametime.places.PlacesEvent;
import com.lotus.sametime.places.SectionEvent;
import com.lotus.sametime.places.SectionListener;
import com.lotus.sametime.places.UserInPlace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Section
extends PlaceMemberImpl {
    static final int STAGE_MEMBER_ID = 1;
    private int m_capacity;
    private Place m_place;
    private Hashtable m_users = new Hashtable();
    private Vector m_sectionListeners = new Vector();

    protected Section(STSession sTSession, Place place, Integer n) {
        this(sTSession, place, n, 0);
    }

    protected Section(STSession sTSession, Place place, Integer n, int n2) {
        super(sTSession, place.getPlaceId(), n);
        this.m_place = place;
        this.m_capacity = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSectionListener(SectionListener sectionListener) {
        Section section = this;
        synchronized (section) {
            Vector vector = (Vector)this.m_sectionListeners.clone();
            vector.addElement(sectionListener);
            this.m_sectionListeners = vector;
        }
        this.addPlaceMemberListener(sectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSectionListener(SectionListener sectionListener) {
        Section section = this;
        synchronized (section) {
            Vector vector = (Vector)this.m_sectionListeners.clone();
            vector.removeElement(sectionListener);
            this.m_sectionListeners = vector;
        }
        this.removePlaceMemberListener(sectionListener);
    }

    public void addAllowedUsers(STUser[] sTUserArray) {
        if (!this.isStage()) {
            return;
        }
        SectionEvent sectionEvent = new SectionEvent(this, 1, this.m_placeId, this.m_memberId, sTUserArray);
        this.sendEvent(sectionEvent);
    }

    public void removeAllowedUsers(STUser[] sTUserArray) {
        if (!this.isStage()) {
            return;
        }
        SectionEvent sectionEvent = new SectionEvent(this, 2, this.m_placeId, this.m_memberId, sTUserArray);
        this.sendEvent(sectionEvent);
    }

    public boolean isStage() {
        return this.m_memberId == 1;
    }

    public int getCapacity() {
        return this.m_capacity;
    }

    public Enumeration getUsers() {
        Hashtable hashtable = (Hashtable)this.m_users.clone();
        return hashtable.elements();
    }

    public Place getPlace() {
        return this.m_place;
    }

    protected void addUser(UserInPlace userInPlace) {
        this.m_users.put(userInPlace.getMemberId(), userInPlace);
    }

    protected UserInPlace getUser(Integer n) {
        Object v = this.m_users.get(n);
        if (v != null) {
            return (UserInPlace)v;
        }
        return null;
    }

    protected void sendSnapshot(PlaceMemberListener placeMemberListener) {
        super.sendSnapshot(placeMemberListener);
        SectionListener sectionListener = (SectionListener)placeMemberListener;
        Vector<UserInPlace> vector = new Vector<UserInPlace>();
        Hashtable hashtable = (Hashtable)this.m_users.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlace userInPlace = (UserInPlace)enumeration.nextElement();
            vector.addElement(userInPlace);
        }
        if (!vector.isEmpty()) {
            Object[] objectArray = new UserInPlace[vector.size()];
            vector.copyInto(objectArray);
            SectionEvent sectionEvent = new SectionEvent((Object)this, -2147483647, (UserInPlace[])objectArray);
            sectionListener.usersEntered(sectionEvent);
        }
    }

    public void processPlacesEvent(PlacesEvent placesEvent) {
        if (placesEvent instanceof PlaceMemberEvent) {
            this.processPlaceMemberEvent((PlaceMemberEvent)placesEvent);
        } else if (placesEvent instanceof SectionEvent) {
            this.processSectionEvent((SectionEvent)placesEvent);
        }
    }

    protected void processSectionEvent(SectionEvent sectionEvent) {
        switch (sectionEvent.getId()) {
            case -2147483647: {
                this.handleUsersEntered(sectionEvent);
                sectionEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.handleUserLeft(sectionEvent);
                sectionEvent.setConsumed(true);
                break;
            }
            case -2147483645: {
                this.handleAddAllowedUsersFailed(sectionEvent);
                sectionEvent.setConsumed(true);
                break;
            }
            case -2147483644: {
                this.handleRemoveAllowedUsersFailed(sectionEvent);
                sectionEvent.setConsumed(true);
            }
        }
    }

    protected void handleUsersEntered(SectionEvent sectionEvent) {
        UserInPlace[] userInPlaceArray = sectionEvent.getUsers();
        for (int i = 0; i < userInPlaceArray.length; ++i) {
            this.addUser(userInPlaceArray[i]);
        }
        Vector vector = this.m_sectionListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SectionListener sectionListener = (SectionListener)enumeration.nextElement();
            sectionListener.usersEntered(sectionEvent);
        }
    }

    protected void handleUserLeft(SectionEvent sectionEvent) {
        this.m_users.remove(sectionEvent.getUser().getMemberId());
        Vector vector = this.m_sectionListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SectionListener sectionListener = (SectionListener)enumeration.nextElement();
            sectionListener.userLeft(sectionEvent);
        }
    }

    protected void handleAddAllowedUsersFailed(SectionEvent sectionEvent) {
        Vector vector = this.m_sectionListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SectionListener sectionListener = (SectionListener)enumeration.nextElement();
            sectionListener.addAllowedUsersFailed(sectionEvent);
        }
    }

    protected void handleRemoveAllowedUsersFailed(SectionEvent sectionEvent) {
        Vector vector = this.m_sectionListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SectionListener sectionListener = (SectionListener)enumeration.nextElement();
            sectionListener.removeAllowedUsersFailed(sectionEvent);
        }
    }
}

