/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.lookup;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STObjectImpl;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.lookup.CommResolveRequest;
import com.lotus.sametime.lookup.GroupContentEvent;
import com.lotus.sametime.lookup.GroupGetterImpl;
import com.lotus.sametime.lookup.LookupEvent;
import com.lotus.sametime.lookup.ResolveImplEvent;
import com.lotus.sametime.lookup.ResolveResponse;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class LookupImpl
extends STCompImpl
implements ChannelListener,
LoginListener,
ServiceListener {
    private static final short VP_RESOLVE = 2;
    private static final int TYPE_USER = 1;
    private static final int TYPE_GROUP = 2;
    private Channel m_channel;
    private boolean m_requestedChannelOpen = false;
    private Vector m_waitingToResolve = new Vector();
    private int m_repliesToReceive = 0;
    private ChannelService m_channelService;
    private CommunityService m_comm;
    private GroupGetterImpl m_groupGetter;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.lookup");

    public LookupImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.lookup.LookupComp", sTSession);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_channelService != null) {
            this.m_groupGetter = new GroupGetterImpl(this.getSession(), this);
        }
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_comm) {
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
            if (this.m_comm.isLoggedIn()) {
                this.m_comm.senseService(21);
            }
        }
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (this.m_channelService == null && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
            this.m_groupGetter = new GroupGetterImpl(this.getSession(), this);
        }
        if (null == this.m_comm && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
            if (this.m_comm.isLoggedIn()) {
                this.m_comm.senseService(21);
            }
        }
    }

    public void resolveNames(Integer n, String[] stringArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl4 && !bl3) {
            ResolveImplEvent resolveImplEvent = new ResolveImplEvent((Object)this, -2147483646, n, -2147287040);
            this.sendEvent(resolveImplEvent);
            return;
        }
        CommResolveRequest commResolveRequest = new CommResolveRequest(n, stringArray, bl, bl2, bl3, bl4);
        if (this.m_channel != null && this.m_channel.isOpen()) {
            this.sendResolveMessage(commResolveRequest);
            return;
        }
        if (!this.m_requestedChannelOpen) {
            this.m_requestedChannelOpen = true;
            this.initChannel();
        }
        this.logRequest(commResolveRequest);
    }

    public void getGroupContent(Integer n, STGroup sTGroup) {
        Debug.stAssert(this.m_groupGetter != null);
        this.m_groupGetter.getGroupContent(n, sTGroup);
    }

    public void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        this.m_requestedChannelOpen = false;
        for (int i = 0; i < this.m_waitingToResolve.size(); ++i) {
            CommResolveRequest commResolveRequest = (CommResolveRequest)this.m_waitingToResolve.elementAt(i);
            this.sendResolveMessage(commResolveRequest);
        }
        this.m_waitingToResolve.removeAllElements();
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        if (channelEvent.getMessageType() == 2) {
            this.handleResolved(channelEvent.getData());
            if (--this.m_repliesToReceive == 0) {
                this.m_channel.close(0, null);
                this.m_channel.removeChannelListener(this);
                this.m_channel = null;
            }
        }
    }

    public void channelClosed(ChannelEvent channelEvent) {
        channelEvent.getChannel().removeChannelListener(this);
        this.m_requestedChannelOpen = false;
        for (int i = 0; i < this.m_waitingToResolve.size(); ++i) {
            CommResolveRequest commResolveRequest = (CommResolveRequest)this.m_waitingToResolve.elementAt(i);
            ResolveImplEvent resolveImplEvent = new ResolveImplEvent((Object)this, -2147483646, commResolveRequest.m_resolveId, channelEvent.getReason());
            this.sendEvent(resolveImplEvent);
        }
        this.m_waitingToResolve.removeAllElements();
        if (channelEvent.getReason() == -2147483635) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelClosed", "LOOKUP SERVICE IS DOWN");
            }
            this.m_comm.senseService(21);
        }
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        this.channelClosed(channelEvent);
    }

    private void initChannel() {
        Debug.stAssert(this.m_channelService != null);
        this.m_channel = this.m_channelService.createChannel(21, 21, 0, EncLevel.ENC_LEVEL_NONE, null, null);
        this.m_channel.addChannelListener(this);
        this.m_channel.open();
    }

    private boolean sendResolveMessage(CommResolveRequest commResolveRequest) {
        Debug.stAssert(this.m_channel != null && this.m_channel.isOpen());
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            commResolveRequest.dump(ndrOutputStream);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendResolveMessage", "IO Exception:\n" + iOException);
            }
            return false;
        }
        byte[] byArray = ndrOutputStream.toByteArray();
        if (this.m_logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < commResolveRequest.m_names.length; ++i) {
                stringBuffer.append(commResolveRequest.m_names[i]);
                stringBuffer.append(", ");
            }
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendResolveMessage", "Resolving: id " + commResolveRequest.m_resolveId + " " + stringBuffer.toString());
        }
        this.m_channel.sendMsg((short)2, byArray, false);
        ++this.m_repliesToReceive;
        return true;
    }

    private void handleResolved(byte[] byArray) {
        ResolveImplEvent resolveImplEvent;
        ResolveResponse[] resolveResponseArray;
        int n;
        int n2;
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.loadMark();
            n2 = ndrInputStream.readInt();
            n = ndrInputStream.readInt();
            int n3 = ndrInputStream.readInt();
            resolveResponseArray = new ResolveResponse[n3];
            for (int i = 0; i < n3; ++i) {
                resolveResponseArray[i] = this.readResolvedUserEntry(ndrInputStream);
            }
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleResolved", "IOExeption while reading resolve results " + iOException);
            }
            return;
        }
        if (n == 0) {
            resolveImplEvent = new ResolveImplEvent((Object)this, -2147483647, new Integer(n2), resolveResponseArray);
            if (this.m_logger.isLoggable(Level.FINER)) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < resolveResponseArray.length; ++i) {
                    stringBuffer.append(resolveResponseArray[i].m_resolveString);
                    stringBuffer.append(", ");
                }
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleResolved", "Resolve Success, id: " + n2 + " " + stringBuffer.toString());
            }
        } else {
            resolveImplEvent = new ResolveImplEvent((Object)this, -2147483646, new Integer(n2), n);
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleResolved", "Resolve Failed, id: " + n2 + " reason: " + n);
            }
        }
        this.sendEvent(resolveImplEvent);
    }

    private void logRequest(CommResolveRequest commResolveRequest) {
        this.m_waitingToResolve.addElement(commResolveRequest);
    }

    private STObject readObjectEntry(NdrInputStream ndrInputStream) throws IOException {
        String string = ndrInputStream.readUTF();
        String string2 = this.m_channel.getRemoteInfo().getCommunityName();
        STId sTId = new STId(string, string2);
        String string3 = ndrInputStream.readUTF();
        String string4 = ndrInputStream.readUTF();
        int n = ndrInputStream.readInt();
        STObjectImpl sTObjectImpl = null;
        switch (n) {
            case 1: {
                sTObjectImpl = new STUser(sTId, string3, string4);
                break;
            }
            case 2: {
                sTObjectImpl = new STGroup(sTId, string3, string4);
                break;
            }
            default: {
                Debug.stAssert(false);
            }
        }
        return sTObjectImpl;
    }

    private ResolveResponse readResolvedUserEntry(NdrInputStream ndrInputStream) throws IOException {
        ResolveResponse resolveResponse = new ResolveResponse();
        ndrInputStream.loadMark();
        resolveResponse.m_statusCode = ndrInputStream.readInt();
        resolveResponse.m_resolveString = ndrInputStream.readUTF();
        int n = ndrInputStream.readInt();
        resolveResponse.m_matches = new STObject[n];
        for (int i = 0; i < n; ++i) {
            resolveResponse.m_matches[i] = this.readObjectEntry(ndrInputStream);
        }
        ndrInputStream.skipMarks();
        return resolveResponse;
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (serviceEvent.getServiceType() == 21) {
            LookupEvent lookupEvent = new LookupEvent(this, 101);
            this.sendEvent(lookupEvent);
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.m_comm.senseService(21);
    }

    public void loggedOut(LoginEvent loginEvent) {
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ResolveImplEvent) {
            this.processResolveImplEvent((ResolveImplEvent)sTEvent);
        } else if (sTEvent instanceof GroupContentEvent) {
            this.processGroupContentEvent((GroupContentEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processResolveImplEvent(ResolveImplEvent resolveImplEvent) {
        switch (resolveImplEvent.getId()) {
            case 1: {
                this.resolveNames(resolveImplEvent.getResolveId(), resolveImplEvent.getNamesList(), resolveImplEvent.getOnlyUnique(), resolveImplEvent.getExhaustiveLookup(), resolveImplEvent.getResolveUsers(), resolveImplEvent.getResolveGroups());
                resolveImplEvent.setConsumed(true);
            }
        }
    }

    protected void processGroupContentEvent(GroupContentEvent groupContentEvent) {
        switch (groupContentEvent.getId()) {
            case 1: {
                this.getGroupContent(groupContentEvent.getRequestId(), groupContentEvent.getGroup());
                groupContentEvent.setConsumed(true);
            }
        }
    }

    public void gotGroupContent(Integer n, STGroup sTGroup, STObject[] sTObjectArray) {
        GroupContentEvent groupContentEvent = new GroupContentEvent(this, -2147483647, n, sTGroup, sTObjectArray);
        this.sendEvent(groupContentEvent);
    }

    public void groupContentFailed(Integer n, int n2) {
        GroupContentEvent groupContentEvent = new GroupContentEvent((Object)this, -2147483646, n, n2);
        this.sendEvent(groupContentEvent);
    }
}

