/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.im;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.im.ImComp;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Im {
    private final Channel m_channel;
    private int m_imType;
    private Vector m_listeners = new Vector();
    private ChannelListener m_channelListener;
    private boolean m_sendImReceived;
    private final ImComp m_imComp;
    private STUserStatus m_acceptingSideStatus;
    private STUser m_partner;
    private static final int OM_VPO_TEXT = 1;
    private static final int OM_VPO_DATA = 2;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.im");

    Im(Channel channel, int n, boolean bl, ImComp imComp, STUser sTUser) {
        this.m_channel = channel;
        this.m_imType = n;
        this.m_sendImReceived = bl;
        this.m_imComp = imComp;
        this.m_partner = sTUser;
        this.m_channelListener = new ChannelListener(){

            public void channelOpened(ChannelEvent channelEvent) {
                Im.this.channelOpened(channelEvent);
            }

            public void channelOpenFailed(ChannelEvent channelEvent) {
                Im.this.channelOpenFailed(channelEvent);
            }

            public void channelClosed(ChannelEvent channelEvent) {
                Im.this.channelClosed(channelEvent);
            }

            public void channelMsgReceived(ChannelEvent channelEvent) {
                Im.this.onMsgReceived(channelEvent);
            }
        };
        this.m_channel.addChannelListener(this.m_channelListener);
    }

    public synchronized void addImListener(ImListener imListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(imListener);
        this.m_listeners = vector;
    }

    public synchronized void removeImListener(ImListener imListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(imListener);
        this.m_listeners = vector;
    }

    public void open() {
        if (!this.m_channel.isOpen()) {
            this.m_channel.open();
        }
    }

    public void close(int n) {
        if (this.m_channel.isOpen()) {
            this.m_channel.close(n, null);
        }
    }

    public void sendText(boolean bl, String string) {
        if (!this.m_channel.isOpen()) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(1);
            ndrOutputStream.writeUTF(string);
            this.m_channel.sendMsg((short)100, ndrOutputStream.toByteArray(), bl);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendText", this + ": Failed on sendText" + iOException.getMessage(), iOException);
            }
            iOException.printStackTrace();
        }
    }

    public void sendData(boolean bl, int n, int n2, byte[] byArray) {
        if (!this.m_channel.isOpen()) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(2);
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeInt(n2);
            if (byArray != null) {
                ndrOutputStream.writeInt(byArray.length);
                ndrOutputStream.write(byArray);
            } else {
                ndrOutputStream.writeInt(0);
            }
            this.m_channel.sendMsg((short)100, ndrOutputStream.toByteArray(), bl);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendData", this + ": Failed on sendData" + iOException.getMessage(), iOException);
            }
            iOException.printStackTrace();
        }
    }

    public boolean isOpen() {
        return this.m_channel.isOpen();
    }

    public STUserInstance getPartnerDetails() {
        return this.m_channel.getRemoteInfo();
    }

    public STUser getPartner() {
        return this.m_partner;
    }

    public STUserStatus getAcceptingSideStatus() {
        return this.m_acceptingSideStatus;
    }

    public int getType() {
        return this.m_imType;
    }

    public EncLevel getEncLevel() {
        return this.m_channel.getEncLevel();
    }

    private void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        try {
            NdrInputStream ndrInputStream = new NdrInputStream(channel.getCreateData());
            int n = ndrInputStream.readInt();
            ndrInputStream.readInt();
            n = ndrInputStream.readInt();
            short s = ndrInputStream.readShort();
            int n2 = ndrInputStream.readInt();
            String string = ndrInputStream.readUTF();
            this.m_acceptingSideStatus = new STUserStatus(s, n2, string);
            if (this.m_sendImReceived) {
                this.m_imComp.notifyImReceived(this);
                this.m_sendImReceived = false;
            } else {
                ImEvent imEvent = new ImEvent(this, 1);
                this.dispatchEvent(imEvent);
            }
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelOpened", this + " Failed on channelCreated" + iOException.getMessage(), iOException);
            }
            iOException.printStackTrace();
        }
    }

    private void channelOpenFailed(ChannelEvent channelEvent) {
        ImEvent imEvent = new ImEvent(this, 2, channelEvent.getReason(), channelEvent.getData());
        this.dispatchEvent(imEvent);
    }

    private void channelClosed(ChannelEvent channelEvent) {
        ImEvent imEvent = new ImEvent(this, 3, channelEvent.getReason(), channelEvent.getData());
        this.dispatchEvent(imEvent);
    }

    private void onMsgReceived(ChannelEvent channelEvent) {
        if (channelEvent.getMessageType() != 100) {
            return;
        }
        try {
            NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
            int n = ndrInputStream.readInt();
            switch (n) {
                case 1: {
                    String string = ndrInputStream.readUTF();
                    ImEvent imEvent = new ImEvent(this, 4, channelEvent.isEncrypted(), string);
                    this.dispatchEvent(imEvent);
                    break;
                }
                case 2: {
                    int n2 = ndrInputStream.readInt();
                    int n3 = ndrInputStream.readInt();
                    int n4 = ndrInputStream.readInt();
                    byte[] byArray = new byte[n4];
                    if (ndrInputStream.read(byArray) == -1) {
                        byArray = null;
                    }
                    ImEvent imEvent = new ImEvent(this, 5, channelEvent.isEncrypted(), n2, n3, byArray);
                    this.dispatchEvent(imEvent);
                }
            }
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "onMsgReceived", this + ": Failed on channelSent" + iOException.getMessage(), iOException);
            }
            iOException.printStackTrace();
        }
    }

    private void dispatchEvent(ImEvent imEvent) {
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ImListener imListener = (ImListener)enumeration.nextElement();
            switch (imEvent.getId()) {
                case 1: {
                    imListener.imOpened(imEvent);
                    break;
                }
                case 3: {
                    imListener.imClosed(imEvent);
                    break;
                }
                case 2: {
                    imListener.openImFailed(imEvent);
                    break;
                }
                case 5: {
                    imListener.dataReceived(imEvent);
                    break;
                }
                case 4: {
                    imListener.textReceived(imEvent);
                }
            }
        }
    }
}

