/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import com.lotus.sametime.guiutils.tree.DefaultSorter;
import com.lotus.sametime.guiutils.tree.EmptyNode;
import com.lotus.sametime.guiutils.tree.Filter;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.Sorter;
import com.lotus.sametime.guiutils.tree.TreeEvent;
import com.lotus.sametime.guiutils.tree.TreeModelListener;
import com.lotus.sametime.guiutils.tree.TreeModelMethods;
import com.lotus.sametime.guiutils.tree.TreeNode;
import java.util.Enumeration;
import java.util.Vector;

public class TreeModel
implements TreeModelMethods {
    public static final short NODE_EXISTS = 0;
    public static final short NODE_DOESNT_EXIST = 1;
    public static final short INSERT_SUCCEEDED = 2;
    public static final short REMOVE_SUCCEEDED = 3;
    public static final short INSERT_UNVISIBLE = 4;
    protected ModelNode m_root;
    protected Vector m_listeners = new Vector();
    private boolean m_sortMode = true;
    private Sorter m_sorter = new DefaultSorter();
    private Filter m_filter = null;

    public TreeModel() {
        this.m_root = new ModelNode("m_root", "m_root");
    }

    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_listeners.addElement(treeModelListener);
    }

    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_listeners.removeElement(treeModelListener);
    }

    private short insertNodeToTree(ModelNode modelNode) {
        int n = 2;
        if (modelNode.m_parent == null) {
            modelNode.m_parent = this.m_root;
        }
        Object object = modelNode.m_parent.m_unfilteredChilds.elements();
        while (object.hasMoreElements()) {
            if (!this.keysEqual(((ModelNode)object.nextElement()).m_key, modelNode.m_key)) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            modelNode.m_parent.m_unfilteredChilds.addElement(modelNode);
            n = 4;
            if (this.m_filter == null || this.m_filter.showNode(modelNode)) {
                n = 2;
                modelNode.m_parent.m_childs.addElement(modelNode);
                if (!modelNode.m_parent.m_childsSorted.isEmpty()) {
                    object = null;
                    boolean bl = false;
                    Enumeration enumeration = modelNode.m_parent.m_childsSorted.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (ModelNode)enumeration.nextElement();
                        if (this.m_sorter.compare((ModelNode)object, modelNode) < 0) continue;
                        bl = true;
                        break;
                    }
                    int n2 = modelNode.m_parent.m_childsSorted.indexOf(object);
                    if (!bl) {
                        modelNode.m_parent.m_childsSorted.addElement(modelNode);
                    } else {
                        modelNode.m_parent.m_childsSorted.insertElementAt(modelNode, n2);
                    }
                } else {
                    modelNode.m_parent.m_childsSorted.addElement(modelNode);
                }
            }
        }
        return (short)n;
    }

    public synchronized void insertNode(ModelNode modelNode, ModelNode modelNode2) {
        modelNode.m_parent = modelNode2;
        this.insertNode(modelNode);
    }

    public synchronized void insertNode(ModelNode modelNode) {
        Vector<ModelNode> vector = new Vector<ModelNode>();
        vector.addElement(modelNode);
        this.insertNodes(vector);
    }

    public synchronized void insertNodes(Vector vector) {
        ModelNode[] modelNodeArray = new ModelNode[vector.size()];
        ModelNode[] modelNodeArray2 = new ModelNode[vector.size()];
        int[] nArray = new int[vector.size()];
        int n = 0;
        TreeNode[] treeNodeArray = vector.elements();
        while (treeNodeArray.hasMoreElements()) {
            ModelNode modelNode = (ModelNode)treeNodeArray.nextElement();
            short s = this.insertNodeToTree(modelNode);
            if (s != 2) continue;
            modelNodeArray[n] = modelNode;
            modelNodeArray2[n] = modelNode.m_parent;
            nArray[n] = this.isSortOn(modelNode.m_parent) ? modelNode.m_parent.m_childsSorted.indexOf(modelNode) : modelNode.m_parent.m_childs.indexOf(modelNode);
            ++n;
        }
        treeNodeArray = new ModelNode[n];
        TreeNode[] treeNodeArray2 = new ModelNode[n];
        int[] nArray2 = new int[n];
        System.arraycopy(modelNodeArray, 0, treeNodeArray, 0, n);
        System.arraycopy(modelNodeArray2, 0, treeNodeArray2, 0, n);
        System.arraycopy(nArray, 0, nArray2, 0, n);
        TreeEvent treeEvent = new TreeEvent(5, treeNodeArray, treeNodeArray2, nArray2);
        this.sendEvent(treeEvent);
    }

    public synchronized void removeNodes(ModelNode[] modelNodeArray) {
        for (int i = 0; i < modelNodeArray.length; ++i) {
            modelNodeArray[i].m_parent.m_unfilteredChilds.removeElement(modelNodeArray[i]);
            modelNodeArray[i].m_parent.m_childs.removeElement(modelNodeArray[i]);
            modelNodeArray[i].m_parent.m_childsSorted.removeElement(modelNodeArray[i]);
        }
        this.sendEvent(new TreeEvent(6, modelNodeArray));
    }

    protected synchronized ModelNode getNode(Object object) {
        return this.searchNode(this.m_root, object);
    }

    protected ModelNode getNode(Object object, ModelNode modelNode) {
        ModelNode modelNode2 = null;
        Vector vector = this.isSortOn(modelNode) ? modelNode.m_childsSorted : modelNode.m_childs;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ModelNode modelNode3 = (ModelNode)enumeration.nextElement();
            if (!this.keysEqual(modelNode3.m_key, object)) continue;
            modelNode2 = modelNode3;
            break;
        }
        return modelNode2;
    }

    public TreeNode getRoot() {
        return this.m_root;
    }

    public synchronized ModelNode getChild(TreeNode treeNode, int n) {
        Vector vector;
        ModelNode modelNode = null;
        Vector vector2 = vector = this.isSortOn(treeNode) ? ((ModelNode)treeNode).m_childsSorted : ((ModelNode)treeNode).m_childs;
        if (n >= 0 && n < vector.size()) {
            modelNode = (ModelNode)vector.elementAt(n);
        }
        return modelNode;
    }

    public int getChildCount(TreeNode treeNode) {
        return ((ModelNode)treeNode).m_childs.size();
    }

    public boolean isLeaf(TreeNode treeNode) {
        return ((ModelNode)treeNode).m_childs.isEmpty();
    }

    public void insertEmptyNode(TreeNode treeNode, EmptyNode emptyNode) {
    }

    public synchronized TreeNode getNext(TreeNode treeNode) {
        Vector vector;
        TreeNode treeNode2 = null;
        Vector vector2 = vector = this.isSortOn(treeNode) ? ((ModelNode)treeNode).m_childsSorted : ((ModelNode)treeNode).m_childs;
        if (treeNode.isExpanded() && !vector.isEmpty()) {
            treeNode2 = (TreeNode)vector.firstElement();
        } else {
            ModelNode modelNode = ((ModelNode)treeNode).m_parent;
            while (treeNode2 == null && modelNode != null) {
                vector = this.isSortOn(modelNode) ? modelNode.m_childsSorted : modelNode.m_childs;
                int n = vector.indexOf(treeNode);
                if (vector.lastElement() == treeNode) {
                    treeNode = modelNode;
                    modelNode = modelNode.m_parent;
                    continue;
                }
                treeNode2 = (TreeNode)vector.elementAt(n + 1);
            }
        }
        return treeNode2;
    }

    protected boolean keysEqual(Object object, Object object2) {
        return object.equals(object2) || object2.equals(object);
    }

    protected ModelNode searchNode(ModelNode modelNode, Object object) {
        if (this.keysEqual(modelNode.m_key, object) && modelNode != this.m_root) {
            return modelNode;
        }
        Enumeration enumeration = modelNode.m_unfilteredChilds.elements();
        while (enumeration.hasMoreElements()) {
            ModelNode modelNode2 = this.searchNode((ModelNode)enumeration.nextElement(), object);
            if (modelNode2 == null) continue;
            return modelNode2;
        }
        return null;
    }

    protected void sendEvent(TreeEvent treeEvent) {
        switch (treeEvent.getType()) {
            case 1: {
                this.notifyNodesChanged(treeEvent.getSources());
                break;
            }
            case 4: {
                this.notifyNodeCollapsed(treeEvent.getSource());
                break;
            }
            case 3: {
                this.notifyNodeExpanded(treeEvent.getSource());
                break;
            }
            case 5: {
                this.notifyNodesInserted(treeEvent.getSources(), treeEvent.getParent(), treeEvent.getIndex());
                break;
            }
            case 6: {
                this.notifyNodesRemoved(treeEvent.getSources());
                break;
            }
            case 2: {
                this.notifyTreeInitialized();
            }
        }
    }

    private void notifyNodesChanged(TreeNode[] treeNodeArray) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.nodesChanged(treeNodeArray);
        }
    }

    private void notifyNodeExpanded(TreeNode treeNode) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.nodeExpanded(treeNode);
        }
    }

    private void notifyNodeCollapsed(TreeNode treeNode) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.nodeCollapsed(treeNode);
        }
    }

    private void notifyNodesInserted(TreeNode[] treeNodeArray, TreeNode[] treeNodeArray2, int[] nArray) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.nodesInserted(treeNodeArray, treeNodeArray2, nArray);
        }
    }

    private void notifyNodesRemoved(TreeNode[] treeNodeArray) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.nodesRemoved(treeNodeArray);
        }
    }

    protected void notifyTreeInitialized() {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.treeModelInitialized();
        }
    }

    public void sortOnOff(boolean bl) {
        if (this.m_sortMode != bl) {
            this.m_sortMode = bl;
            this.notifyTreeInitialized();
        }
    }

    public synchronized void setSorter(Sorter sorter) {
        if (null != sorter) {
            this.m_sorter = sorter;
            this.reSort();
            if (this.m_sortMode) {
                this.notifyTreeInitialized();
            }
        }
    }

    public synchronized void reSort() {
        this.reSort(this.m_root);
    }

    protected synchronized void reSort(ModelNode modelNode) {
        if (null == modelNode || modelNode.getChilds().size() == 0) {
            return;
        }
        Vector vector = modelNode.m_childsSorted;
        Vector<ModelNode> vector2 = new Vector<ModelNode>();
        for (int i = vector.size(); i > 0; --i) {
            ModelNode modelNode2 = (ModelNode)vector.elementAt(0);
            for (int j = 1; j < i; ++j) {
                int n = this.m_sorter.compare((ModelNode)vector.elementAt(j), modelNode2);
                if (n > 0) continue;
                modelNode2 = (ModelNode)vector.elementAt(j);
            }
            vector2.addElement(modelNode2);
            vector.removeElement(modelNode2);
        }
        modelNode.m_childsSorted = vector2;
        Enumeration enumeration = modelNode.getChilds().elements();
        while (enumeration.hasMoreElements()) {
            this.reSort((ModelNode)enumeration.nextElement());
        }
    }

    public boolean getSortMode() {
        return this.m_sortMode;
    }

    public boolean isSortOn(TreeNode treeNode) {
        return this.getSortMode();
    }

    public void resetTree() {
        this.m_root = new ModelNode("m_root", "m_root");
        this.notifyTreeInitialized();
    }

    public synchronized void setFilter(Filter filter) {
        this.m_filter = filter;
        this.reFilter((ModelNode)this.getRoot());
        this.reSort();
        this.notifyTreeInitialized();
    }

    protected Filter getFilter() {
        return this.m_filter;
    }

    protected synchronized void reFilter(ModelNode modelNode) {
        if (null == modelNode || modelNode.m_unfilteredChilds.size() == 0) {
            return;
        }
        modelNode.m_childs.removeAllElements();
        modelNode.m_childsSorted.removeAllElements();
        for (int i = 0; i < modelNode.m_unfilteredChilds.size(); ++i) {
            ModelNode modelNode2 = (ModelNode)modelNode.m_unfilteredChilds.elementAt(i);
            if (null != this.m_filter && !this.m_filter.showNode(modelNode2)) continue;
            modelNode.m_childs.addElement(modelNode2);
            modelNode.m_childsSorted.addElement(modelNode2);
        }
        Enumeration enumeration = modelNode.m_unfilteredChilds.elements();
        while (enumeration.hasMoreElements()) {
            this.reFilter((ModelNode)enumeration.nextElement());
        }
    }
}

