/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.statusbar;

import com.lotus.sametime.guiutils.helpers.GraphicsHelpers;
import com.lotus.sametime.guiutils.helpers.TextHelpers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class Statusbar
extends Panel {
    private String m_defaultStatus = "";
    private String m_status = "";
    private int m_height = 0;
    private Font m_font = null;
    private Image m_encImage = null;
    private int m_imagePad = 3;

    public Statusbar(String string, Font font, int n) {
        this.m_defaultStatus = string;
        this.m_status = string;
        this.m_font = font;
        this.m_height = n;
    }

    public Statusbar(String string, Font font, int n, Image image) {
        this(string, font, n);
        this.m_encImage = image;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        if (this.m_encImage == null) {
            GraphicsHelpers.drawFlat3dRect(graphics, 0, 1, this.getSize().width - 1, this.getSize().height - 2, false);
        } else {
            n = this.getSize().width - (this.m_imagePad * 2 + this.m_encImage.getWidth(this) + 2);
            GraphicsHelpers.drawFlat3dRect(graphics, 0, 1, n, this.getSize().height - 2, false);
            GraphicsHelpers.drawFlat3dRect(graphics, n + 2, 1, this.getSize().width - 1, this.getSize().height - 2, false);
            graphics.drawImage(this.m_encImage, n + 2 + this.m_imagePad, 6, this);
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.m_font);
        graphics.drawString(TextHelpers.truncateText(this.m_status, graphics.getFontMetrics(), n != 0 ? n : this.getSize().width - 8), 4, 16);
    }

    public void setStatus(String string) {
        this.m_status = string;
        this.repaint();
    }

    public void resetStatus() {
        this.m_status = this.m_defaultStatus;
        this.repaint();
    }

    public void setEncImage(Image image) {
        this.m_encImage = image;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, this.m_height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

