/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.misc;

import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STTextArea
extends TextArea
implements KeyListener {
    private Clipboard m_clipboard = null;
    private boolean m_isSelected = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.guiutils.misc");

    public STTextArea() {
        this.commonInit();
    }

    public STTextArea(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
        this.commonInit();
    }

    private void commonInit() {
        block2: {
            try {
                this.m_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block2;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "commonInit", "Security violation on getSystemClipboard");
            }
        }
        this.addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (keyEvent.isControlDown()) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 67: {
                    this.copy();
                    keyEvent.consume();
                    break;
                }
                case 86: {
                    this.paste();
                    keyEvent.consume();
                    break;
                }
                case 88: {
                    this.cut();
                    keyEvent.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void cut() {
        String string = this.getSelectedText();
        if (string == null) {
            return;
        }
        if (this.m_clipboard != null) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            this.m_clipboard.setContents(new StringSelection(string), null);
            String string2 = this.getText();
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n2, string2.length());
            String string5 = string3 + string4;
            this.setText(string5);
            this.setCaretPosition(string5.length());
        }
    }

    public void copy() {
        String string = this.getSelectedText();
        if (string == null || this.m_clipboard == null) {
            return;
        }
        this.m_clipboard.setContents(new StringSelection(string), null);
    }

    public void paste() {
        if (this.m_clipboard == null) {
            return;
        }
        try {
            String string;
            Transferable transferable = this.m_clipboard.getContents(null);
            if (null == transferable) {
                return;
            }
            String string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            int n3 = this.getCaretPosition();
            if (n3 < this.getText().length()) {
                String string3 = this.getText().substring(0, n3);
                string3 = string3 + string2;
                string = string3 + this.getText().substring(n3);
            } else {
                string = this.getText() + string2;
            }
            this.setText(string);
            this.setCaretPosition(n + string2.length());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println("STTextArea : Cannot retreive data from the clipboard");
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("STTextArea : Cannot retreive data from the clipboard");
            iOException.printStackTrace();
        }
    }
}

