/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.chat;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.chat.ChatArea;
import com.lotus.sametime.guiutils.chat.ChatLine;
import com.lotus.sametime.guiutils.chat.ChatParagraph;
import com.lotus.sametime.guiutils.chat.ChatSelection;
import com.lotus.sametime.guiutils.chat.ChatSelector;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import java.util.Vector;

public final class ChatTranscript
extends Panel
implements AdjustmentListener,
KeyListener,
ActionListener {
    private String COPY_ITEM = "Copy";
    private String SELECT_ALL_ITEM = "Select All";
    private static final int EXTRA_HEIGHT = 3;
    private ChatArea m_area = null;
    protected ChatParagraph[] m_paraArray = null;
    private static FontMetrics m_fm = null;
    private static int m_nameWidth = 0;
    private PopupMenu m_popup;
    private static int m_textMargin = 2;
    protected static int m_lineHeight = 0;
    private int m_maxNbOfPara = 0;
    private int m_paraCount = 0;
    private static int m_maxNbOfCharsInName = 0;
    protected ChatSelector m_selector;
    protected Image m_offscreenImage = null;
    protected int m_width = 0;
    protected int m_height = 0;
    protected int m_textHeight = 0;
    private int m_lastScrollPosition = 0;
    private final String TAB_REPLACEMENT = "        ";
    protected boolean m_hasFocus = false;

    ChatTranscript(ChatArea chatArea, int n, Font font, int n2, ResourceBundle resourceBundle) {
        if (null != resourceBundle) {
            if (resourceBundle.getString("MENUITEM_COPY") != null) {
                this.COPY_ITEM = resourceBundle.getString("MENUITEM_COPY");
            }
            if (resourceBundle.getString("MENUITEM_SELECT_ALL") != null) {
                this.SELECT_ALL_ITEM = resourceBundle.getString("MENUITEM_SELECT_ALL");
            }
        }
        this.init(chatArea, n, font, n2);
    }

    ChatTranscript(ChatArea chatArea, int n, Font font, int n2, String string, String string2) {
        this.COPY_ITEM = string;
        this.SELECT_ALL_ITEM = string2;
        this.init(chatArea, n, font, n2);
    }

    private void init(ChatArea chatArea, int n, Font font, int n2) {
        this.m_area = chatArea;
        this.m_maxNbOfPara = n;
        this.m_paraArray = new ChatParagraph[n];
        if (StaticProps.m_bUnixOS) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.window);
        }
        this.m_selector = new ChatSelector(this);
        if (m_fm == null) {
            m_fm = this.getFontMetrics(font);
            m_maxNbOfCharsInName = n2;
            m_nameWidth = m_maxNbOfCharsInName * m_fm.charWidth('n');
            m_lineHeight = m_fm.getHeight();
        }
        this.m_area.getVAdjustable().setUnitIncrement(m_lineHeight);
        this.addKeyListener(this);
        this.m_popup = new PopupMenu();
        this.m_popup.add(this.COPY_ITEM);
        this.m_popup.add(this.SELECT_ALL_ITEM);
        this.add(this.m_popup);
        this.m_popup.addActionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(2));
        Adjustable adjustable = this.m_area.getVAdjustable();
        adjustable.addAdjustmentListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ChatTranscript.this.m_hasFocus = true;
            }

            public void focusLost(FocusEvent focusEvent) {
                ChatTranscript.this.m_hasFocus = false;
            }
        };
        this.addFocusListener(focusAdapter);
    }

    protected String truncateName(String string) {
        if (m_fm.stringWidth(string) <= m_nameWidth) {
            return string;
        }
        while (m_fm.stringWidth((string = string.substring(0, string.length() - 1)) + "..") > m_nameWidth) {
        }
        return string + "..";
    }

    private void removeParagraphs() {
        int n = this.m_maxNbOfPara / 2;
        this.m_paraCount = this.m_maxNbOfPara - n;
        System.arraycopy(this.m_paraArray, n, this.m_paraArray, 0, this.m_paraCount);
        int n2 = this.m_paraArray[0].getLinePosByLineNo((int)0).y - this.getInitialHeight();
        for (int i = 0; i < this.m_maxNbOfPara; ++i) {
            if (i < this.m_paraCount) {
                this.m_paraArray[i].updatePara(n, n2);
                continue;
            }
            this.m_paraArray[i] = null;
        }
    }

    protected void deleteAll() {
        this.m_paraCount = 0;
        this.m_textHeight = 3;
        for (int i = 0; i < this.m_maxNbOfPara; ++i) {
            this.m_paraArray[i] = null;
        }
        this.setTranscriptHeight();
    }

    private void setTranscriptHeight() {
        Dimension dimension = this.m_area.getViewportSize();
        int n = this.m_textHeight > dimension.height ? this.m_area.getVScrollbarWidth() : 0;
        dimension.width -= n;
        int n2 = this.m_textHeight < dimension.height ? dimension.height : this.m_textHeight;
        this.setSize(dimension.width, n2);
        this.m_area.validate();
        if (this.m_textHeight > dimension.height) {
            int n3 = this.m_textHeight - dimension.height;
            this.m_area.setScrollPosition(0, n3);
        }
        this.repaint();
    }

    protected void addParagraph(Color color, String string, String string2) {
        Object object;
        int n;
        String string3;
        int n2;
        if (this.m_paraCount == this.m_maxNbOfPara) {
            this.removeParagraphs();
        }
        if (!string.equals("")) {
            string = this.truncateName(string);
        }
        if ((n2 = (string3 = string2 == null || string2.equals("") ? " " : string2).indexOf("\t", n = 0)) != -1) {
            object = new StringBuffer();
            while (n2 != -1) {
                ((StringBuffer)object).append(string3.substring(n, n2));
                ((StringBuffer)object).append("        ");
                n = ++n2;
                n2 = string3.indexOf("\t", n);
            }
            ((StringBuffer)object).append(string3.substring(n, string3.length()));
            string3 = ((StringBuffer)object).toString();
        }
        object = new ChatParagraph(this, color, string, string3, this.m_paraCount);
        ++this.m_paraCount;
        this.setTranscriptHeight();
    }

    protected int getFirstVisibleParaIdx() {
        int n;
        if (this.empty()) {
            return -1;
        }
        if (StaticProps.m_bAIXOS) {
            return 0;
        }
        int n2 = this.m_area.getScrollPosition().y;
        int n3 = n2 + this.m_area.getViewportSize().height;
        for (n = 0; n < this.m_paraCount - 1 && !this.m_paraArray[n].IsVisible(n2, n3); ++n) {
        }
        return n;
    }

    protected int getLastVisibleParaIdx(int n) {
        int n2;
        if (this.empty()) {
            return -1;
        }
        if (StaticProps.m_bAIXOS) {
            return this.m_paraCount - 1;
        }
        int n3 = this.m_area.getScrollPosition().y;
        int n4 = n3 + this.m_area.getViewportSize().height;
        for (n2 = n; n2 < this.m_paraCount - 1 && this.m_paraArray[n2 + 1].IsVisible(n3, n4); ++n2) {
        }
        return n2;
    }

    protected int getParaIdxByPos(int n) {
        int n2 = 0;
        if (n >= this.getInitialHeight()) {
            if (n > this.m_textHeight - 3) {
                n2 = this.m_paraCount - 1;
            } else {
                while (n > this.computeLineYPos(n2 + 1, 0)) {
                    ++n2;
                }
            }
        }
        return n2;
    }

    protected ChatSelection getSelectionByPoint(Point point) {
        int n = this.getParaIdxByPos(point.y);
        ChatLine chatLine = this.m_paraArray[n].getLineByPos(point);
        int n2 = chatLine == null ? this.m_paraArray[n].getParaLength() : chatLine.getOffsetByPos(m_fm, point.x);
        return new ChatSelection(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        boolean bl;
        int n = this.m_area.getViewportSize().height;
        if (this.m_width <= 0 || n <= 0) {
            return;
        }
        int n2 = this.m_area.getScrollPosition().y;
        int n3 = StaticProps.m_bAIXOS ? this.m_textHeight : n;
        Image image = this.createImage(this.m_width, n3);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.m_width, this.m_height);
        graphics2.translate(0, -n2);
        graphics2.setFont(m_fm.getFont());
        int n4 = this.getFirstVisibleParaIdx();
        int n5 = this.getLastVisibleParaIdx(n4);
        boolean bl2 = bl = n4 >= 0;
        if (bl) {
            for (int i = n4; i <= n5; ++i) {
                this.m_paraArray[i].paintParagraph(graphics2);
            }
        }
        graphics.drawImage(image, 0, n2, this);
        graphics2.dispose();
        if (this.m_hasFocus) {
            this.m_selector.highlightSelection(graphics, null, null);
        }
    }

    protected void CalcTranscript() {
        for (int i = 0; i < this.m_paraCount; ++i) {
            this.m_paraArray[i].recalcLines();
        }
    }

    protected boolean mouseIsOverURL(Point point) {
        if (this.m_paraCount == 0) {
            return false;
        }
        boolean bl = false;
        int n = this.getParaIdxByPos(point.y);
        ChatLine chatLine = this.m_paraArray[n].getLineByPos(point);
        if (chatLine != null) {
            int n2;
            bl = chatLine.getLineSegments() == null ? false : ((n2 = chatLine.getOffsetByPos(m_fm, point.x) - chatLine.getStartOffset()) == chatLine.getLineLength() ? false : chatLine.offsetIsURL(n2));
        }
        return bl;
    }

    protected void requestURL(Point point) {
        int n;
        ChatSelection chatSelection;
        ChatLine chatLine;
        Vector vector;
        int n2;
        int n3 = this.getParaIdxByPos(point.y);
        ChatParagraph chatParagraph = this.m_paraArray[n3];
        ChatLine chatLine2 = chatParagraph.getLineByPos(point);
        int n4 = chatLine2.getOffsetByPos(m_fm, point.x) - chatLine2.getStartOffset();
        int n5 = chatLine2.getSegmentIdx(n4);
        int n6 = chatLine2.getSegmentStart(n5) + chatLine2.getStartOffset();
        int n7 = chatLine2.getSegmentStart(n5 + 1) + chatLine2.getStartOffset();
        int n8 = chatParagraph.findLineIdxByStartOffset(chatLine2.getStartOffset());
        if (n6 == chatLine2.getStartOffset()) {
            for (n2 = n8; n2 > 1 && (vector = (chatLine = chatParagraph.getParaLine(n2 - 1)).getLineSegments()) != null; --n2) {
                chatSelection = (ChatSelection)vector.lastElement();
                n = chatSelection.getParaIdx();
                if (n <= 0) continue;
                n6 = chatSelection.getOffset() + chatLine.getStartOffset();
                if (vector.size() > 1) break;
            }
        }
        if (n7 == chatLine2.getEndOffset()) {
            for (n2 = n8; n2 < chatParagraph.getNbOfLines() - 1 && (vector = (chatLine = chatParagraph.getParaLine(n2 + 1)).getLineSegments()) != null; ++n2) {
                chatSelection = (ChatSelection)vector.firstElement();
                n = chatSelection.getParaIdx();
                if (n <= 0) continue;
                if (vector.size() > 1) {
                    n7 = chatLine.getSegmentStart(1) + chatLine.getStartOffset();
                    break;
                }
                n7 = chatLine.getEndOffset();
            }
        }
        String string = chatParagraph.getTextByOffsets(n6, n7);
        this.m_area.requestURL(string);
    }

    public Dimension getPreferredSize() {
        int n = m_nameWidth + 100;
        int n2 = this.m_textHeight;
        int n3 = this.m_area.getViewportSize().width;
        int n4 = this.m_area.getViewportSize().height;
        n = Math.max(n, n3);
        n2 = Math.max(n2, n4);
        int n5 = this.m_textHeight > n4 ? this.m_area.getVScrollbarWidth() : 0;
        if (n2 > 0 && ((n -= n5) != this.m_width || n2 != this.m_height)) {
            this.m_height = n2;
            if (n != this.m_width) {
                this.m_width = n;
                if (this.m_paraCount > 0) {
                    int n6 = n5;
                    this.CalcTranscript();
                    if (n6 == 0) {
                        int n7 = n5 = this.m_textHeight > n4 ? this.m_area.getVScrollbarWidth() : 0;
                        if (n5 > 0) {
                            this.m_width = n -= n5;
                            this.CalcTranscript();
                        }
                    }
                    n2 = this.m_textHeight;
                    this.m_height = n2 = Math.max(n2, n4);
                }
            }
            Rectangle rectangle = this.getBounds();
            this.repaint(100L, rectangle.x, rectangle.y, n, n2);
        }
        return new Dimension(n, n2);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        if (n != this.m_lastScrollPosition) {
            this.repaint(100L);
            this.m_lastScrollPosition = n;
        }
    }

    protected int getLineHeight() {
        return m_lineHeight;
    }

    protected int getTextMargin() {
        return m_textMargin;
    }

    protected int computeLineXPos(int n) {
        if (n == 0) {
            return m_textMargin;
        }
        return m_nameWidth + m_textMargin * 3;
    }

    protected int computeLineYPos(int n, int n2) {
        int n3;
        if (n2 == 0) {
            if (n == 0) {
                n3 = this.getInitialHeight();
            } else {
                ChatParagraph chatParagraph = this.m_paraArray[n - 1];
                n3 = chatParagraph.getLinePosByLineNo((int)(chatParagraph.getNbOfLines() - 1)).y;
                n3 += m_lineHeight;
            }
        } else {
            ChatParagraph chatParagraph = this.m_paraArray[n];
            if (n2 == 1) {
                n3 = chatParagraph.getLinePosByLineNo((int)0).y;
            } else {
                n3 = chatParagraph.getLinePosByLineNo((int)(n2 - 1)).y;
                n3 += m_lineHeight;
            }
        }
        return n3;
    }

    protected int getTranscriptWidth() {
        return this.m_width - m_nameWidth - m_textMargin * 4;
    }

    protected int getTextHeight() {
        return this.m_textHeight;
    }

    protected void setTextHeight(ChatParagraph chatParagraph) {
        this.m_textHeight = this.computeLineYPos(chatParagraph.getParaIdx() + 1, 0) + 3;
    }

    protected int getInitialHeight() {
        return 0;
    }

    protected FontMetrics getFontMetrics() {
        return m_fm;
    }

    protected ChatParagraph getParaByIdx(int n) {
        return this.m_paraArray[n];
    }

    protected int getParaCount() {
        return this.m_paraCount;
    }

    protected ChatArea getArea() {
        return this.m_area;
    }

    protected Rectangle getViewPortRect() {
        return new Rectangle(this.m_area.getScrollPosition(), this.m_area.getViewportSize());
    }

    protected void removeSelection() {
        this.m_selector.removeSelection();
    }

    protected void copySelectionToClip() {
        this.m_selector.copySelectionToClip();
    }

    protected void selectAll() {
        this.m_selector.selectAll();
    }

    protected String[] getAllText() {
        String[] stringArray = new String[this.m_paraCount];
        for (int i = 0; i < this.m_paraCount; ++i) {
            stringArray[i] = this.m_paraArray[i].getParaText();
        }
        return stringArray;
    }

    protected String getSelectedText() {
        return this.m_selector.getSelectedText();
    }

    protected void clear() {
        if (!this.empty()) {
            this.deleteAll();
        }
    }

    protected boolean empty() {
        return this.m_paraCount == 0;
    }

    protected void showPopup(int n, int n2, boolean bl) {
        MenuItem menuItem = this.m_popup.getItem(0);
        menuItem.setEnabled(bl && this.m_selector.hasClipboardAccess());
        this.m_popup.show(this, n, n2);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            switch (keyEvent.getKeyCode()) {
                case 65: {
                    this.selectAll();
                    break;
                }
                case 67: {
                    this.copySelectionToClip();
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.COPY_ITEM.equals(string)) {
            this.copySelectionToClip();
        } else if (this.SELECT_ALL_ITEM.equals(string)) {
            this.m_selector.selectAll();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean hasFocus() {
        return this.m_hasFocus;
    }
}

