/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.chat;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.chat.ChatSendFieldEvent;
import com.lotus.sametime.guiutils.chat.ChatSendFieldListener;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatSendField
extends TextArea
implements KeyListener,
ActionListener,
MouseListener,
TextListener {
    private boolean m_isTabFromTA;
    private Vector m_listeners;
    private Clipboard m_clipboard;
    private boolean m_isEmpty;
    private boolean m_isSelected;
    private STBundle m_resourceFile;
    private PopupMenu m_popupMenu;
    private MenuItem m_miCut;
    private MenuItem m_miCopy;
    private MenuItem m_miPaste;
    private MenuItem m_miClearAll;
    private int m_startSelection;
    private int m_endSelection;
    private Logger m_logger;

    public ChatSendField(int n, int n2, Font font, STBundle sTBundle) {
        block4: {
            super(null, n, n2, 1);
            this.m_isTabFromTA = true;
            this.m_listeners = new Vector();
            this.m_clipboard = null;
            this.m_isEmpty = true;
            this.m_isSelected = false;
            this.m_startSelection = -1;
            this.m_endSelection = -1;
            this.m_logger = Logger.getLogger("com.lotus.sametime.guiutils.chat");
            this.m_resourceFile = sTBundle;
            this.setFont(font);
            try {
                this.m_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block4;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Security violation on getSystemClipboard");
            }
        }
        this.initPopupMenu();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addTextListener(this);
        this.setForeground(SystemColor.textText);
        if (StaticProps.m_bUnixOS) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.window);
        }
    }

    private void initPopupMenu() {
        this.m_popupMenu = new PopupMenu();
        this.m_miCut = new MenuItem(this.m_resourceFile.getString("MENUITEM_CUT"));
        this.m_popupMenu.add(this.m_miCut);
        this.m_miCut.addActionListener(this);
        this.m_miCopy = new MenuItem(this.m_resourceFile.getString("MENUITEM_COPY"));
        this.m_popupMenu.add(this.m_miCopy);
        this.m_miCopy.addActionListener(this);
        this.m_miPaste = new MenuItem(this.m_resourceFile.getString("MENUITEM_PASTE"));
        this.m_popupMenu.add(this.m_miPaste);
        this.m_miPaste.addActionListener(this);
        this.m_popupMenu.addSeparator();
        this.m_miClearAll = new MenuItem(this.m_resourceFile.getString("MENUITEM_CLEAR_ALL"));
        this.m_popupMenu.add(this.m_miClearAll);
        this.m_miClearAll.addActionListener(this);
        this.add(this.m_popupMenu);
        if (StaticProps.m_bUnixOS) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.window);
        }
    }

    public void submitText() {
        String string = this.getText();
        if (string.length() > 10000) {
            string = string.substring(0, 10000);
        }
        this.clear();
        this.textSubmitted(string);
    }

    public void addSendFieldListener(ChatSendFieldListener chatSendFieldListener) {
        this.m_listeners.addElement(chatSendFieldListener);
    }

    public void removeSendFieldListener(ChatSendFieldListener chatSendFieldListener) {
        this.m_listeners.removeElement(chatSendFieldListener);
    }

    public void cut() {
        String string = this.getSelectedText();
        if (string == null) {
            return;
        }
        if (this.m_clipboard != null) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            this.m_clipboard.setContents(new StringSelection(string), null);
            this.replaceRange("", n, n2);
            this.setCaretPosition(n);
            this.updateSelection();
        }
    }

    public void copy() {
        String string = this.getSelectedText();
        if (string == null || this.m_clipboard == null) {
            return;
        }
        this.m_clipboard.setContents(new StringSelection(string), null);
    }

    public void paste() {
        if (this.m_clipboard == null) {
            return;
        }
        try {
            Transferable transferable = this.m_clipboard.getContents(null);
            if (null == transferable) {
                return;
            }
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            this.replaceRange(string, n, n2);
            this.setCaretPosition(n + string.length());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println("ChatSendField: Cannot retreive data from the clipboard");
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("ChatSendField: Cannot retreive data from the clipboard");
            iOException.printStackTrace();
        }
        this.updateSelection();
    }

    public synchronized void clear() {
        this.setText("");
        this.updateSelection();
        this.updateContent();
    }

    public synchronized void removeSelection() {
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
        this.updateSelection();
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getID() == 900) {
            this.updateContent();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (keyEvent.isControlDown() && !keyEvent.isAltDown()) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 67: {
                    this.copy();
                    keyEvent.consume();
                    break;
                }
                case 86: {
                    this.paste();
                    keyEvent.consume();
                    break;
                }
                case 88: {
                    this.cut();
                    keyEvent.consume();
                }
            }
        }
        if (c == '\n' && (keyEvent.getModifiers() & 1) == 0) {
            if ((keyEvent.getModifiers() & 2) != 0) {
                String string = this.getText() + "\n";
                this.setText(string);
                this.setCaretPosition(this.getText().length());
            } else {
                this.submitText();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.updateSelection();
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\t') {
            String string = this.getText();
            this.setText(string.trim());
            this.setCaretPosition(string.length());
            Object object = keyEvent.getSource();
            if (this.m_isTabFromTA) {
                this.nextFocus();
                this.m_isTabFromTA = false;
            } else {
                keyEvent.consume();
                this.m_isTabFromTA = true;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_miCut) {
            this.cut();
        }
        if (actionEvent.getSource() == this.m_miCopy) {
            this.copy();
        }
        if (actionEvent.getSource() == this.m_miPaste) {
            this.paste();
        }
        if (actionEvent.getSource() == this.m_miClearAll) {
            this.clear();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.setSelectionStart(this.m_startSelection);
            this.setSelectionEnd(this.m_endSelection);
            this.updateMenuItems();
            this.m_popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateSelection();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.m_isTabFromTA = true;
    }

    public boolean hasClipboardAccess() {
        return this.m_clipboard != null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof MouseEvent) || aWTEvent.getID() != 501 || (((MouseEvent)aWTEvent).getModifiers() & 4) == 0) {
            this.m_startSelection = this.getSelectionStart();
            this.m_endSelection = this.getSelectionEnd();
        }
        super.processEvent(aWTEvent);
    }

    private void updateContent() {
        int n = this.getText().length();
        if (n == 0 && !this.m_isEmpty || n > 0 && this.m_isEmpty) {
            this.m_isEmpty = !this.m_isEmpty;
            this.contentChanged();
            if (this.m_isEmpty) {
                this.stoppedResponse();
            } else {
                this.startedResponse();
            }
        }
    }

    private void updateSelection() {
        boolean bl;
        boolean bl2 = bl = this.getSelectionStart() == this.getSelectionEnd();
        if (bl && this.m_isSelected || !bl && !this.m_isSelected) {
            this.m_isSelected = !this.m_isSelected;
            this.selectionChanged();
        }
    }

    private void textSubmitted(String string) {
        ChatSendFieldEvent chatSendFieldEvent = new ChatSendFieldEvent(this, string);
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ChatSendFieldListener chatSendFieldListener = (ChatSendFieldListener)this.m_listeners.elementAt(i);
            chatSendFieldListener.textSubmitted(chatSendFieldEvent);
        }
    }

    private void contentChanged() {
        ChatSendFieldEvent chatSendFieldEvent = new ChatSendFieldEvent(this, this.m_isEmpty, this.m_isSelected);
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ChatSendFieldListener chatSendFieldListener = (ChatSendFieldListener)this.m_listeners.elementAt(i);
            chatSendFieldListener.contentChanged(chatSendFieldEvent);
        }
    }

    private void startedResponse() {
        ChatSendFieldEvent chatSendFieldEvent = new ChatSendFieldEvent(this);
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ChatSendFieldListener chatSendFieldListener = (ChatSendFieldListener)this.m_listeners.elementAt(i);
            chatSendFieldListener.startedResponse(chatSendFieldEvent);
        }
    }

    private void stoppedResponse() {
        ChatSendFieldEvent chatSendFieldEvent = new ChatSendFieldEvent(this);
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ChatSendFieldListener chatSendFieldListener = (ChatSendFieldListener)this.m_listeners.elementAt(i);
            chatSendFieldListener.stoppedResponse(chatSendFieldEvent);
        }
    }

    private void selectionChanged() {
        ChatSendFieldEvent chatSendFieldEvent = new ChatSendFieldEvent(this, this.m_isEmpty, this.m_isSelected);
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ChatSendFieldListener chatSendFieldListener = (ChatSendFieldListener)this.m_listeners.elementAt(i);
            chatSendFieldListener.selectionChanged(chatSendFieldEvent);
        }
    }

    private void updateMenuItems() {
        String string = this.getSelectedText();
        String string2 = this.getText();
        if (this.m_clipboard == null) {
            this.m_miCut.setEnabled(false);
            this.m_miCopy.setEnabled(false);
            this.m_miPaste.setEnabled(false);
        } else {
            this.m_miCut.setEnabled(string.length() != 0);
            this.m_miCopy.setEnabled(string.length() != 0);
            this.m_miPaste.setEnabled(this.m_clipboard.getContents(null) != null);
        }
        this.m_miClearAll.setEnabled(string2.length() != 0);
    }
}

