/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.directory;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.directory.Directory;
import com.lotus.sametime.directory.DirectoryEvent;
import com.lotus.sametime.directory.DirectoryImpl;
import com.lotus.sametime.directory.DirectoryService;
import com.lotus.sametime.directory.DirectoryServiceListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryComp
extends STComp
implements DirectoryService {
    private Vector m_listeners = new Vector();
    private DirectoryImpl m_impl = null;
    private Hashtable m_dirsHandles = new Hashtable();
    private Hashtable m_dirsRequestsTable = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.directory");

    public DirectoryComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.directory.DirectoryComp", sTSession);
        this.m_impl = new DirectoryImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof DirectoryEvent) {
            this.processDirectoryEvent((DirectoryEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    private void processDirectoryEvent(DirectoryEvent directoryEvent) {
        switch (directoryEvent.getId()) {
            case 8: {
                this.getDirectoriesSucceeded(directoryEvent);
                break;
            }
            case 14: {
                this.serviceDown(directoryEvent);
                break;
            }
            case 7: 
            case 13: {
                this.dispatchServiceEvent(directoryEvent);
                directoryEvent.setConsumed(true);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.dispatchDirectoryEvent(directoryEvent);
                directoryEvent.setConsumed(true);
            }
        }
    }

    private void dispatchServiceEvent(DirectoryEvent directoryEvent) {
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        directoryEvent.setSource(this);
        while (enumeration.hasMoreElements()) {
            DirectoryServiceListener directoryServiceListener = (DirectoryServiceListener)enumeration.nextElement();
            switch (directoryEvent.getId()) {
                case 7: {
                    directoryServiceListener.allDirectoriesQueryFailed(directoryEvent);
                    break;
                }
                case 8: {
                    directoryServiceListener.allDirectoriesQueried(directoryEvent);
                    break;
                }
                case 14: {
                    directoryServiceListener.serviceUnavailable(directoryEvent);
                    break;
                }
                case 13: {
                    directoryServiceListener.serviceAvailable(directoryEvent);
                }
            }
        }
    }

    private void serviceDown(DirectoryEvent directoryEvent) {
        this.dispatchServiceEvent(directoryEvent);
    }

    private void getDirectoriesSucceeded(DirectoryEvent directoryEvent) {
        Directory[] directoryArray = directoryEvent.getDirectories();
        for (int i = 0; i < directoryArray.length; ++i) {
            directoryArray[i].setDirectoryComp(this);
        }
        this.dispatchServiceEvent(directoryEvent);
    }

    private void dispatchDirectoryEvent(DirectoryEvent directoryEvent) {
        Directory directory = (Directory)this.m_dirsRequestsTable.remove(directoryEvent.getRequestId());
        if (directoryEvent.getId() == 10) {
            this.m_dirsHandles.put(directory, new Integer(directoryEvent.getHandle()));
            directory.setMaxEntries(directoryEvent.getChunkSize());
        }
        directory.dispatchEvent(directoryEvent);
    }

    void closeDirectory(Directory directory) {
        Integer n = DirectoryComp.getUniqueId();
        Integer n2 = (Integer)this.m_dirsHandles.remove(directory);
        if (null != n2) {
            this.sendEvent(new DirectoryEvent(this, 2, n, 0, n2));
        }
    }

    void openDirectory(Directory directory) {
        Integer n = DirectoryComp.getUniqueId();
        this.m_dirsRequestsTable.put(n, directory);
        this.sendEvent(new DirectoryEvent((Object)this, 1, n, directory));
    }

    Integer queryEntries(Directory directory, boolean bl, short s) {
        Integer n = (Integer)this.m_dirsHandles.get(directory);
        if (null == n) {
            System.err.println("Directory Error tried to query a directoywhich is not currentlly open");
            n = new Integer(Integer.MAX_VALUE);
        }
        Integer n2 = DirectoryComp.getUniqueId();
        this.m_dirsRequestsTable.put(n2, directory);
        DirectoryEvent directoryEvent = new DirectoryEvent((Object)this, 3, n2, (int)n, s, bl);
        this.sendEvent(directoryEvent);
        return n2;
    }

    Integer queryEntries(Directory directory, String string, short s) {
        Integer n = (Integer)this.m_dirsHandles.get(directory);
        if (null == n) {
            System.err.println("Directory Error tried to query a directoywhich is not currentlly open");
            n = new Integer(Integer.MAX_VALUE);
        }
        Integer n2 = DirectoryComp.getUniqueId();
        this.m_dirsRequestsTable.put(n2, directory);
        if (string != null) {
            string = string.trim();
        }
        DirectoryEvent directoryEvent = new DirectoryEvent((Object)this, 5, n2, (int)n, s, string);
        this.sendEvent(directoryEvent);
        return n2;
    }

    public synchronized void addDirectoryServiceListener(DirectoryServiceListener directoryServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(directoryServiceListener);
        this.m_listeners = vector;
    }

    public synchronized void removeDirectoryServiceListener(DirectoryServiceListener directoryServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(directoryServiceListener);
        this.m_listeners = vector;
    }

    public void queryAllDirectories() {
        this.sendEvent(new DirectoryEvent((Object)this, 0, DirectoryComp.getUniqueId()));
    }
}

