/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class WnetURLConnection
extends HttpURLConnection {
    static final String WNET_LIB_NAME = "sturlcon10";
    private ByteArrayOutputStream m_outputBuffer = new ByteArrayOutputStream();
    private Hashtable m_headers = new Hashtable();
    private String m_proxyHost;
    private int m_proxyPort;
    private boolean m_useIESettings;
    private String m_proxyUserName;
    private String m_proxyPass;
    private String m_httpUsername;
    private String m_httpPass;
    private boolean m_outputFlushed = false;
    private ByteArrayInputStream m_inputStream = null;
    private volatile int m_responseCode = -1;
    private int m_contentLength = -1;
    private static boolean c_libLoaded = false;

    public WnetURLConnection(URL uRL) {
        super(uRL);
        this.m_useIESettings = true;
    }

    public WnetURLConnection(URL uRL, String string, String string2, String string3, int n, boolean bl, String string4, String string5) {
        super(uRL);
        this.m_httpUsername = string;
        this.m_httpPass = string2;
        this.m_proxyHost = string3;
        this.m_proxyPort = n;
        this.m_useIESettings = bl;
        this.m_proxyUserName = string4 == null ? "" : string4;
        this.m_proxyPass = string5 == null ? "" : string5;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
        if (!c_libLoaded) {
            System.loadLibrary(WNET_LIB_NAME);
            c_libLoaded = true;
        }
        if (this.getDoOutput()) {
            this.method = "POST";
        } else if (this.method == null) {
            this.method = "GET";
        }
        byte[] byArray = this.m_outputBuffer.toByteArray();
        boolean bl = this.getAllowUserInteraction();
        boolean bl2 = this.url.getProtocol().equalsIgnoreCase("https");
        int n = bl2 ? 443 : 80;
        int n2 = this.url.getPort();
        n2 = n2 == -1 ? n : n2;
        String string = this.makeReqHeaderString();
        byte[] byArray2 = this.getHttpWithAuth(this.url.getHost(), n2, this.url.getFile(), this.method, this.m_httpUsername, this.m_httpPass, this.m_proxyHost, this.m_proxyPort, this.m_useIESettings, this.m_proxyUserName, this.m_proxyPass, bl, byArray, bl2, string);
        if (byArray2 == null) {
            throw new IOException("Can't get " + this.url + ", status = " + this.m_responseCode);
        }
        this.m_contentLength = byArray2.length;
        this.m_inputStream = new ByteArrayInputStream(byArray2);
    }

    public void disconnect() {
    }

    public InputStream getInputStream() throws IOException {
        if (!this.getDoInput()) {
            throw new IOException("input not requested");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.m_inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.getDoOutput()) {
            throw new IOException("output not requested");
        }
        if (this.connected) {
            throw new IOException("Can't write to server after connection");
        }
        return this.m_outputBuffer;
    }

    public boolean usingProxy() {
        return this.m_proxyHost != null && (!this.m_proxyHost.equals(this.url.getHost()) || this.m_proxyPort != this.url.getPort());
    }

    public void setRequestProperty(String string, String string2) {
        this.m_headers.put(string, string2);
    }

    public String getHeaderField(String string) {
        return (String)this.m_headers.get(string.toLowerCase());
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public int getContentLength() {
        return this.m_contentLength;
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.m_responseCode;
    }

    private String makeReqHeaderString() {
        if (this.m_headers == null || this.m_headers.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_headers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.m_headers.get(string);
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(string2);
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    private native byte[] getHttpWithAuth(String var1, int var2, String var3, String var4, String var5, String var6, String var7, int var8, boolean var9, String var10, String var11, boolean var12, byte[] var13, boolean var14, String var15);
}

