/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.STHttpURLOutput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class STHttpURLConnection
extends HttpURLConnection {
    private Socket m_connection = null;
    private STHttpURLOutput m_outputBuffer = null;
    private Hashtable m_headers = null;
    private String m_proxyHost = null;
    private int m_proxyPort = 0;
    private boolean m_outputFlushed = false;
    private DataInputStream m_inputStream = null;
    private ConnectionInitializer m_initializer = null;
    private int m_responseCode = -1;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public STHttpURLConnection(URL uRL, String string, int n, ConnectionInitializer connectionInitializer) {
        super(uRL);
        this.m_proxyHost = string;
        this.m_proxyPort = n;
        this.m_outputBuffer = new STHttpURLOutput(this);
        this.m_headers = new Hashtable();
        this.m_initializer = connectionInitializer;
    }

    public synchronized void connect() throws IOException {
        String string = this.usingProxy() ? this.m_proxyHost : this.url.getHost();
        int n = this.usingProxy() ? this.m_proxyPort : this.url.getPort();
        try {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "connect", this.toString() + ".connect(): " + string + ":" + n);
            }
            this.m_connection = this.safeGetSocket(string, n);
            if (this.m_connection != null) {
                this.m_inputStream = new DataInputStream(this.m_connection.getInputStream());
                this.connected = this.m_connection != null;
            } else {
                this.connected = false;
            }
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "connect", "Couldn't connect", exception);
            }
            throw new IOException("Couldn't connect");
        }
    }

    public void disconnect() {
        block4: {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "disconnect", this.toString() + ".disconnect()");
            }
            try {
                if (this.connected) {
                    this.m_connection.close();
                }
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block4;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "disconnect", null, exception);
            }
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.getDoInput()) {
            throw new IOException("input not requested");
        }
        if (!this.connected) {
            this.connect();
        }
        this.send(new byte[1], 0);
        return this.m_inputStream;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.getDoOutput()) {
            throw new IOException("output not requested");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.connected ? this.m_outputBuffer : null;
    }

    public void send(byte[] byArray, int n) {
        block15: {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "send", this.toString() + ".send()");
            }
            this.m_responseCode = -1;
            if (this.m_outputFlushed) {
                return;
            }
            try {
                String string;
                StringTokenizer stringTokenizer;
                PrintStream printStream = null;
                String string2 = null;
                if (!this.m_headers.contains("Host")) {
                    this.setRequestProperty("Host", this.url.getHost());
                }
                if (this.getDoOutput() && n > 0) {
                    this.setRequestMethod("POST");
                    this.setRequestProperty("Content-Length", "" + n);
                } else {
                    this.setRequestMethod("GET");
                }
                if (!this.m_headers.containsKey("Content-Type")) {
                    this.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                }
                printStream = new PrintStream(this.m_connection.getOutputStream());
                printStream.print(this.getRequestMethod() + " " + (this.usingProxy() ? this.url.toExternalForm() : this.url.getFile()) + " HTTP/1.0\r\n");
                if (this.m_headers.size() > 0) {
                    stringTokenizer = this.m_headers.keys();
                    while (stringTokenizer.hasMoreElements()) {
                        string = (String)stringTokenizer.nextElement();
                        printStream.print(string + ": " + this.m_headers.get(string) + "\r\n");
                    }
                }
                printStream.print("\r\n");
                if (this.getDoOutput() && n > 0) {
                    printStream.write(byArray, 0, n);
                }
                printStream.flush();
                this.m_outputFlushed = true;
                string2 = this.m_inputStream.readLine();
                if (string2.length() > 0) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextElement();
                    this.m_responseCode = Integer.parseInt((String)stringTokenizer.nextElement());
                    if (this.m_responseCode != 200) {
                        throw new IOException("Invalid HTTP Response = " + this.m_responseCode);
                    }
                    this.responseMessage = (String)stringTokenizer.nextElement();
                    while (null != (string2 = this.m_inputStream.readLine()) && string2.length() != 0) {
                        int n2 = string2.indexOf(":");
                        if (n2 == -1) continue;
                        string = string2.substring(0, n2).trim();
                        String string3 = "";
                        if (n2 < string2.length()) {
                            string3 = string2.substring(n2 + 1).trim();
                        }
                        this.m_headers.put(string.toLowerCase(), string3);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block15;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "send", null, exception);
            }
        }
    }

    public boolean usingProxy() {
        return this.m_proxyHost != null && (!this.m_proxyHost.equals(this.url.getHost()) || this.m_proxyPort != this.url.getPort());
    }

    public void setRequestProperty(String string, String string2) {
        this.m_headers.put(string, string2);
    }

    public void setRequestMethod(String string) {
        this.method = string;
    }

    public String getHeaderField(String string) {
        return (String)this.m_headers.get(string.toLowerCase());
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    protected Socket safeGetSocket(String string, int n) throws IOException {
        try {
            return new Socket(string, n);
        }
        catch (SecurityException securityException) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "safeGetSocket", "Failed to create a socket. Trying to get privilage");
            }
            return new Socket(string, n);
        }
    }

    public int getResponseCode() throws IOException {
        return this.m_responseCode;
    }
}

