/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.logging.TkLogger;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.Sender;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class RC2Sender
extends Sender {
    static final int MAX_BLOCK_SIZE = 4096;
    private Connection m_realConn;
    private byte[] m_key;
    private RC2Cipher m_encCipher;
    private NdrOutputStream m_buffer;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public RC2Sender(Connection connection, byte[] byArray) {
        this.m_realConn = connection;
        this.m_buffer = new NdrOutputStream();
        this.m_encCipher = new RC2Cipher();
        this.m_encCipher.init(0, byArray);
    }

    void stopSender() {
        if (this.m_stopped) {
            return;
        }
        super.stopSender();
    }

    protected void initialize() {
    }

    protected void cleanup() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "cleanup", "RC2Sender: closing real connection");
        }
        this.m_realConn.close();
    }

    private void encryptAndSendBlock(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        if (n > 0 || n2 < byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            byArray = byArray2;
        }
        byArray2 = this.m_encCipher.doFinal(byArray);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "encryptAndSendBlock", "RC2Sender: encrypted message = ");
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "encryptAndSendBlock", TkLogger.formatBytes(byArray2));
        }
        this.m_buffer.reset();
        this.m_buffer.writeBytes(byArray2);
        this.m_realConn.sendMessage(this.m_buffer.toByteArray(), (byte)0);
    }

    protected void send(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; i += 4096) {
            int n = byArray.length - i;
            int n2 = n >= 4096 ? 4096 : n;
            this.encryptAndSendBlock(byArray, i, n2);
        }
    }

    protected boolean sendKeepAlive() {
        return true;
    }
}

