/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.RC2Receiver;
import com.lotus.sametime.core.util.connection.RC2Sender;
import java.io.IOException;
import java.net.InetAddress;

public class RC2Connection
extends Connection {
    private Connection m_realConn;
    private byte[] m_key;

    public RC2Connection(Connection connection, byte[] byArray) {
        super(0L);
        this.m_realConn = connection;
        this.m_key = byArray;
        if (this.m_realConn.isReady()) {
            this.wrapConnection();
        }
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        Debug.stAssert(!this.m_realConn.isReady() && !this.m_realConn.isReadyForInitialSend());
        this.wrapConnection();
        this.m_realConn.initializeConnection(string, connectionInitializer);
    }

    protected boolean isReady() {
        return this.m_realConn.isReady();
    }

    protected boolean isReadyForInitialSend() {
        return this.m_realConn.isReadyForInitialSend();
    }

    protected void wrapConnection() {
        this.setDataListener(this.m_realConn.getDataListener());
        this.m_realConn.setDataListener(null);
        this.setClosedListener(this.m_realConn.getClosedListener());
        this.m_realConn.setClosedListener(null);
        try {
            this.m_receiver = new RC2Receiver(this.m_realConn, this.m_key, this);
            this.m_sender = new RC2Sender(this.m_realConn, this.m_key);
            this.m_receiver.startReceiver();
            this.m_sender.startSender();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
    }

    public void setKeepAliveParams(long l, byte[] byArray) {
        this.m_realConn.setKeepAliveParams(l, byArray);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.m_realConn.getConnectionInfo();
    }

    public InetAddress getLocalAddress() {
        return this.m_realConn.getLocalAddress();
    }
}

