/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.HybridPollingSender;
import com.lotus.sametime.core.util.connection.Receiver;
import java.io.DataInputStream;
import java.io.IOException;

class HybridPollingReceiver
extends Receiver {
    private DataInputStream m_inStream = null;

    protected HybridPollingReceiver(HybridPollingSender hybridPollingSender, Connection connection) throws IOException {
        super(connection);
        this.m_inStream = new DataInputStream(hybridPollingSender.getPolledInputStream());
    }

    protected void initialize() throws IOException {
    }

    protected void cleanup() {
        if (this.m_inStream != null) {
            try {
                this.m_inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_inStream = null;
        }
    }

    protected void interruptReading() {
        try {
            this.m_inStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void receive(byte[] byArray) throws IOException {
        this.m_inStream.readFully(byArray);
    }
}

