/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.HybridPollingReceiver;
import com.lotus.sametime.core.util.connection.HybridPollingSender;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HybridPollingConnection
extends Connection {
    private short m_port;
    private URL m_hostUrl = null;
    private boolean m_useWNet = false;
    private boolean m_secure = false;
    boolean m_popupAuthDialog = false;
    boolean m_useSystemProxySettings = false;
    String m_proxyServer;
    short m_proxyPort;
    String m_proxyUserName;
    String m_proxyPass;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public HybridPollingConnection(String string, short s, boolean bl, boolean bl2, String string2, short s2, boolean bl3, String string3, String string4, boolean bl4, long l) {
        super(l);
        this.setHost(string);
        this.m_port = s;
        this.m_useWNet = bl;
        this.m_secure = bl2;
        this.m_proxyServer = string2;
        this.m_proxyPort = s2;
        this.m_useSystemProxySettings = bl3;
        this.m_proxyUserName = string3;
        this.m_proxyPass = string4;
        this.m_popupAuthDialog = bl4;
    }

    public HybridPollingConnection(URL uRL, boolean bl, String string, short s, boolean bl2, String string2, String string3, boolean bl3, long l) {
        super(l);
        this.m_useWNet = bl;
        this.m_hostUrl = uRL;
        this.m_proxyServer = string;
        this.m_proxyPort = s;
        this.m_useSystemProxySettings = bl2;
        this.m_proxyUserName = string2;
        this.m_proxyPass = string3;
        this.m_popupAuthDialog = bl3;
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        if (this.getHost() == null) {
            this.setHost(string);
        }
        Debug.stAssert(this.getHost() != null || this.m_hostUrl != null);
        try {
            HybridPollingSender hybridPollingSender = new HybridPollingSender(string, this.m_port, this.m_hostUrl, this.m_useWNet, this.m_secure, this.m_proxyServer, this.m_proxyPort, this.m_useSystemProxySettings, this.m_proxyUserName, this.m_proxyPass, this.m_popupAuthDialog);
            this.m_sender = hybridPollingSender;
            this.m_receiver = new HybridPollingReceiver(hybridPollingSender, this);
            this.m_sender.startSender();
            this.m_receiver.startReceiver();
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "initializeConnection", "Can't create sender: ", iOException);
            }
            if (this.m_receiver != null) {
                this.m_receiver.stopReceiver();
            }
            throw iOException;
        }
    }

    public URL getHostUrl() {
        return this.m_hostUrl;
    }

    public int getPort() {
        return this.m_port;
    }

    public ConnectionInfo getConnectionInfo() {
        int n;
        String string = this.getHost();
        if (string == null && this.getHostUrl() != null) {
            string = this.getHostUrl().getHost();
        }
        if ((n = this.getPort()) == 0 && this.getHostUrl() != null && (n = this.getHostUrl().getPort()) == -1) {
            String string2 = this.getHostUrl().getProtocol();
            if (string2.equalsIgnoreCase("http")) {
                n = 80;
            } else if (string2.equalsIgnoreCase("https")) {
                n = 443;
            }
        }
        ConnectionInfo connectionInfo = new ConnectionInfo(8, n, this.m_proxyServer, this.m_proxyPort, this.m_proxyUserName, this.m_proxyPass, this.m_useWNet, string, this.getHostUrl());
        return connectionInfo;
    }
}

