/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Base64Encoder;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.DirectSocketConnection;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpsConnection
extends DirectSocketConnection {
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_HANDSHAKE = 1;
    private static final int STATE_CONNECTED = 2;
    private static final String CRLF = "\r\n";
    private static final int RESPONSE_BUFFER_SIZE = 256;
    private int m_state = 0;
    private String m_proxyServer;
    private int m_proxyPort;
    private String m_proxyLogin;
    private String m_proxyPassword;
    private byte[] m_responseBuf = new byte[256];
    private int m_responseIdx = 0;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public HttpsConnection(String string, int n, String string2, int n2, String string3, String string4, long l) {
        super(string, n, l);
        this.m_proxyServer = string2;
        this.m_proxyPort = n2;
        this.m_proxyLogin = string3;
        this.m_proxyPassword = string4;
    }

    public HttpsConnection(int n, String string, int n2, String string2, String string3, long l) {
        this(null, n, string, n2, string2, string3, l);
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        String string2 = this.getHost();
        this.setHost(null);
        int n = this.getPort();
        this.setPort(this.m_proxyPort);
        super.initializeConnection(this.m_proxyServer, connectionInitializer);
        this.setHost(string2 == null ? string : string2);
        Debug.stAssert(this.getHost() != null);
        this.setPort(n);
        this.m_state = 1;
        this.sendHndShakeMsg(string, n);
    }

    protected boolean isReadyForInitialSend() {
        return super.isReadyForInitialSend() && this.m_state == 2;
    }

    protected void sendHndShakeMsg(String string, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("CONNECT " + string + ":" + n + " HTTP/1.0");
        stringBuffer.append(CRLF);
        if (this.m_proxyLogin != null) {
            String string2 = this.createHttpsAuthData(this.m_proxyLogin, this.m_proxyPassword);
            stringBuffer.append(string2);
        }
        stringBuffer.append(CRLF);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendHndShakeMsg", "Sending connect request: " + stringBuffer.toString());
        }
        this.m_sender.send(stringBuffer.toString().getBytes());
    }

    void onReceive(byte[] byArray) {
        if (this.m_state == 2) {
            super.onReceive(byArray);
            return;
        }
        if (this.m_responseIdx == this.m_responseBuf.length) {
            int n = this.m_responseIdx * 2;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.m_responseBuf, 0, byArray2, 0, this.m_responseIdx);
            this.m_responseBuf = byArray2;
        }
        Debug.stAssert(byArray.length == 1);
        this.m_responseBuf[this.m_responseIdx++] = byArray[0];
        if (this.m_responseIdx < 4 || this.m_responseBuf[this.m_responseIdx - 4] != 13 || this.m_responseBuf[this.m_responseIdx - 3] != 10 || this.m_responseBuf[this.m_responseIdx - 2] != 13 || this.m_responseBuf[this.m_responseIdx - 1] != 10) {
            return;
        }
        String string = new String(this.m_responseBuf, 0, this.m_responseIdx);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onReceive", "HttpsConnection: proxy response string:" + string);
        }
        if (this.parseProxyResponse(string)) {
            this.m_state = 2;
        } else {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "onReceive", "Proxy error occured: " + string);
            }
            this.close(-2147483126);
        }
    }

    protected boolean parseProxyResponse(String string) {
        boolean bl;
        block3: {
            bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                String string2;
                int n;
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("HTTP/") && (n = Integer.parseInt(string2 = stringTokenizer.nextToken())) == 200) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block3;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "parseProxyResponse", "HttpsConnection: Couldn't parse proxy response");
            }
        }
        return bl;
    }

    protected String createHttpsAuthData(String string, String string2) {
        String string3 = string + ":" + (string2 == null ? "" : string2);
        String string4 = Base64Encoder.encode(string3.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Authorization: Basic ");
        stringBuffer.append(string4);
        stringBuffer.append(CRLF);
        stringBuffer.append("Proxy-authorization: Basic ");
        stringBuffer.append(string4);
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    public String getProxyServer() {
        return this.m_proxyServer;
    }

    public int getProxyPort() {
        return this.m_proxyPort;
    }

    public String getProxyLogin() {
        return this.m_proxyLogin;
    }

    public String getProxyPassword() {
        return this.m_proxyPassword;
    }

    public ConnectionInfo getConnectionInfo() {
        return new ConnectionInfo(3, this.getPort(), this.getProxyServer(), this.getProxyPort(), this.getProxyLogin(), this.getProxyPassword());
    }
}

