/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.PollingReceiver;
import com.lotus.sametime.core.util.connection.PollingSender;
import com.lotus.sametime.core.util.connection.ProxiedHttpReceiver;
import com.lotus.sametime.core.util.connection.ProxiedHttpSender;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpConnection
extends Connection {
    static final String COMMUNITY_RESOURCE_NAME = "/communityCBR/";
    private int m_httpPort;
    private URL m_hostUrl = null;
    private boolean m_useOurOwnConnection = false;
    private String m_proxyHost = null;
    private int m_proxyPort;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public HttpConnection(String string, int n, long l) {
        super(l);
        this.setHost(string);
        this.m_httpPort = n;
        this.m_useOurOwnConnection = false;
    }

    public HttpConnection(int n, long l) {
        this(null, n, l);
    }

    public HttpConnection(URL uRL, long l) {
        super(l);
        this.m_hostUrl = uRL;
        this.m_useOurOwnConnection = false;
    }

    public HttpConnection(String string, int n, long l, String string2, int n2) {
        super(l);
        this.setHost(string);
        this.m_httpPort = n;
        this.m_useOurOwnConnection = true;
        this.m_proxyHost = string2;
        this.m_proxyPort = n2;
    }

    public HttpConnection(int n, long l, String string, int n2) {
        this(null, n, l, string, n2);
    }

    public HttpConnection(URL uRL, long l, String string, int n) {
        super(l);
        this.m_useOurOwnConnection = true;
        this.m_hostUrl = uRL;
        this.m_proxyHost = string;
        this.m_proxyPort = n;
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        if (this.getHost() == null) {
            this.setHost(string);
        }
        Debug.stAssert(this.getHost() != null || this.m_hostUrl != null);
        if (this.m_useOurOwnConnection) {
            this.initializeSTURLConnection(this.getHost(), connectionInitializer);
        } else {
            this.initializePoolingConnection(this.getHost(), connectionInitializer);
        }
    }

    private void initializeSTURLConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        ProxiedHttpReceiver proxiedHttpReceiver = new ProxiedHttpReceiver(string, this.m_httpPort, this.m_hostUrl, this, this.m_proxyHost, this.m_proxyPort);
        ProxiedHttpSender proxiedHttpSender = new ProxiedHttpSender(string, this.m_httpPort, this.m_hostUrl, null, this.m_proxyHost, this.m_proxyPort);
        proxiedHttpReceiver.setInitializer(connectionInitializer);
        proxiedHttpReceiver.startReceiver();
        proxiedHttpReceiver.setInitializer(null);
        byte[] byArray = proxiedHttpReceiver.getMasterId();
        try {
            proxiedHttpSender.setMasterId(byArray);
            proxiedHttpSender.startSender();
        }
        catch (IOException iOException) {
            proxiedHttpReceiver.stopReceiver();
            throw iOException;
        }
        this.m_receiver = proxiedHttpReceiver;
        this.m_sender = proxiedHttpSender;
    }

    private void initializePoolingConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        try {
            PollingSender pollingSender = new PollingSender(string, this.m_httpPort, this.m_hostUrl);
            this.m_sender = pollingSender;
            this.m_receiver = new PollingReceiver(pollingSender, this);
            this.m_sender.startSender();
            this.m_receiver.startReceiver();
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "initializePoolingConnection", "Can't create sender: ", iOException);
            }
            if (this.m_receiver != null) {
                this.m_receiver.stopReceiver();
            }
            throw iOException;
        }
    }

    public URL getHostUrl() {
        return this.m_hostUrl;
    }

    public int getHttpPort() {
        return this.m_httpPort;
    }

    public String getProxyServer() {
        return this.m_proxyHost;
    }

    public int getProxyPort() {
        return this.m_proxyPort;
    }

    public boolean isOurOwnConnection() {
        return this.m_useOurOwnConnection;
    }

    public ConnectionInfo getConnectionInfo() {
        int n;
        String string = this.getHost();
        if (string == null && this.getHostUrl() != null) {
            string = this.getHostUrl().getHost();
        }
        if ((n = this.getHttpPort()) == 0 && this.getHostUrl() != null && (n = this.getHostUrl().getPort()) == -1) {
            String string2 = this.getHostUrl().getProtocol();
            if (string2.equalsIgnoreCase("http")) {
                n = 80;
            } else if (string2.equalsIgnoreCase("https")) {
                n = 443;
            }
        }
        ConnectionInfo connectionInfo = this.isOurOwnConnection() ? new ConnectionInfo(2, n, this.getProxyServer(), this.getProxyPort(), null, null, this.isOurOwnConnection(), string, this.getHostUrl()) : new ConnectionInfo(6, n, null, 0, null, null, this.isOurOwnConnection(), string, this.getHostUrl());
        return connectionInfo;
    }
}

