/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.connection.ClosedListener;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.VMLock;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConnectionInitializer
implements Runnable,
ClosedListener {
    private static final String THREAD_NAME = "Lil' Steve's connection initializer. ";
    private static final int CONNECTION_POLLS_SLEEP = 250;
    private static final int PAUSE_CHECK_SLEEP = 250;
    private static int c_threadCount = 0;
    private Connection m_connection;
    private String m_host;
    private Exception m_initializationException;
    private boolean m_connectionClosed = false;
    private byte[] m_initialMsg = null;
    private volatile boolean m_threadStopped = false;
    private volatile boolean m_timerPaused = false;
    String m_proxyHost = null;
    String m_proxyPort = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    ConnectionInitializer(Connection connection, String string, byte[] byArray) {
        this.m_host = string;
        this.m_connection = connection;
        this.m_initialMsg = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws IOException {
        this.m_initializationException = null;
        this.m_connection.setClosedListener(this);
        Thread thread = new Thread((Runnable)this, THREAD_NAME + ++c_threadCount);
        Object object = VMLock.getLocker();
        synchronized (object) {
            this.saveSystemProxySettings();
            thread.start();
            this.join(thread, this.m_connection.getTimeout());
            if (thread.isAlive()) {
                thread.stop();
            }
            this.restoreSystemProxySettings();
        }
        if (!this.m_connection.isReady()) {
            this.m_connection.setClosedListener(null);
            this.m_connection.close();
            if (this.m_logger.isLoggable(Level.FINEST)) {
                if (this.m_connectionClosed) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "initialize", "Connection failed");
                } else {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "initialize", "Connection timed out");
                }
            }
            object = null;
            if (this.m_initializationException != null) {
                if (this.m_initializationException instanceof IOException) {
                    object = (IOException)this.m_initializationException;
                } else {
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "initialize", this + "Exception during initialization ", this.m_initializationException);
                    }
                    object = new IOException("Exception during initialization.");
                }
            } else {
                object = new IOException("Timed out");
            }
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_connection.initializeConnection(this.m_host, this);
        }
        catch (Exception exception) {
            this.m_initializationException = exception;
            this.m_connectionClosed = true;
            return;
        }
        ConnectionInitializer connectionInitializer = this;
        synchronized (connectionInitializer) {
            while (!this.m_connection.isReadyForInitialSend() && !this.m_threadStopped) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.m_threadStopped && this.m_initialMsg != null) {
                this.m_connection.sendMessage(this.m_initialMsg, (byte)0);
            }
            while (!this.m_connection.isReady() && !this.m_threadStopped) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_threadStopped = true;
        }
    }

    synchronized void stopInitializerThread() {
        this.m_threadStopped = true;
        this.notifyAll();
    }

    protected void join(Thread thread, long l) {
        boolean bl;
        boolean bl2 = bl = l == 0L;
        while ((bl || l > 0L) && thread.isAlive()) {
            try {
                thread.join(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l -= 250L;
            while (this.m_timerPaused && thread.isAlive()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void pauseSleep() {
        this.m_timerPaused = true;
    }

    void restartSleep() {
        this.m_timerPaused = false;
    }

    public synchronized void onConnectionClosed(int n, Connection connection) {
        this.m_connectionClosed = true;
        this.stopInitializerThread();
    }

    protected void saveSystemProxySettings() {
        block2: {
            try {
                Properties properties = System.getProperties();
                this.m_proxyHost = (String)properties.get("socksProxyHost");
                this.m_proxyPort = (String)properties.get("socksProxyPort");
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block2;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "saveSystemProxySettings", "Failed to get system propeties");
            }
        }
    }

    protected void restoreSystemProxySettings() {
        if (this.m_proxyHost != null) {
            Properties properties = System.getProperties();
            properties.put("socksProxyHost", this.m_proxyHost);
            if (this.m_proxyPort != null) {
                properties.put("socksProxyPort", this.m_proxyPort);
            }
            System.setProperties(properties);
            this.m_proxyHost = null;
        }
    }
}

