/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.EmptyStackException;
import java.util.Vector;

public class NdrInputStream
extends DataInputStream {
    private ByteArrayInputStream m_byteStream;
    private int m_originalLength;
    private Vector m_markups;

    public NdrInputStream(ByteArrayInputStream byteArrayInputStream) {
        super(byteArrayInputStream);
        this.m_byteStream = byteArrayInputStream;
        this.m_originalLength = this.m_byteStream.available();
    }

    public NdrInputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public void loadMark() throws IOException {
        if (this.m_markups == null) {
            this.m_markups = new Vector();
        }
        this.m_markups.addElement(new Integer(this.readInt()));
    }

    public void skipMarks() throws IOException {
        this.skipMarks(1);
    }

    public void skipMarks(int n) throws IOException {
        if (this.m_markups == null || n > this.m_markups.size()) {
            throw new EmptyStackException();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = (Integer)this.m_markups.lastElement();
            this.m_markups.removeElementAt(this.m_markups.size() - 1);
        }
        this.skipBytes(n2 - this.position());
    }

    public int position() {
        return this.m_originalLength - this.m_byteStream.available();
    }

    public byte[] readBytes() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public InetAddress readInetAddress() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        int[] nArray = new int[]{byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF, byArray[3] & 0xFF};
        String string = "" + nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        return InetAddress.getByName(string);
    }
}

