/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Debug {
    public static final String DATE_TIME_FORMAT = "MM/dd H:mm:ss.SSS";
    public static int m_debugLevel = 0;
    private static final int DEFAULT_DEBUG_LEVEL = 3;
    private static Date c_date = new Date();
    private static PrintStream m_out = System.err;

    public static final void setOutputStream(PrintStream printStream) {
        m_out = printStream;
    }

    public static final void print(String string) {
        Debug.print(3, string);
    }

    public static final void print(int n, String string) {
        if (n <= m_debugLevel) {
            Debug.printlnT(3, string);
        }
    }

    public static final void println(String string) {
        Debug.printlnT(3, string);
    }

    public static final void println(int n, String string) {
        if (n <= m_debugLevel) {
            Debug.printlnT(3, string);
        }
    }

    public static final void printlnT(int n, String string) {
        if (n <= m_debugLevel) {
            c_date.setTime(System.currentTimeMillis());
            StringBuffer stringBuffer = new StringBuffer(Thread.currentThread().getName());
            stringBuffer.setLength(15);
            for (int i = Thread.currentThread().getName().length(); i < 15; ++i) {
                stringBuffer.setCharAt(i, ' ');
            }
            StringBuffer stringBuffer2 = new StringBuffer(string.length() + 30);
            stringBuffer2.append('[');
            stringBuffer2.append(new SimpleDateFormat(DATE_TIME_FORMAT).format(c_date));
            stringBuffer2.append("]   ");
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append("   ");
            stringBuffer2.append(string);
            m_out.println(stringBuffer2.toString());
        }
    }

    public static final void printException(int n, String string, Throwable throwable) {
        if (n <= m_debugLevel) {
            if (string != null) {
                Debug.printlnT(3, string);
            }
            throwable.printStackTrace(m_out);
        }
    }

    public static final void printByte(int n, byte by) {
        if (n > m_debugLevel) {
            return;
        }
        int n2 = by & 0xFF;
        String string = Integer.toHexString(n2);
        if (string.length() < 2) {
            string = "0" + string;
        }
        m_out.print(string);
    }

    public static final void printByte(int n, byte[] byArray) {
        if (n > m_debugLevel) {
            return;
        }
        if (byArray == null) {
            m_out.println("<null>");
            return;
        }
        for (int i = 0; i < byArray.length; i += 16) {
            int n2;
            m_out.println("");
            Debug.printByte(n, (byte)(i >> 8));
            Debug.printByte(n, (byte)(i & 0xFF));
            m_out.print(" -  ");
            int n3 = byArray.length - i;
            int n4 = n3 > 16 ? 16 : n3;
            for (n2 = 0; n2 < n4; ++n2) {
                Debug.printByte(n, byArray[i + n2]);
                m_out.print(" ");
            }
            if (n4 < 16) {
                while (n2 < 16) {
                    m_out.print("   ");
                    ++n2;
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (byArray[i + n2] > 32 && byArray[i + n2] <= 127) {
                    m_out.print("" + (char)byArray[i + n2]);
                    continue;
                }
                m_out.print(".");
            }
        }
        m_out.println("");
    }

    public static final void stAssert(boolean bl) {
        if (!bl && m_debugLevel != 0) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    public static final boolean isDebug() {
        return m_debugLevel >= 3;
    }

    public static final boolean isDebugLevel(int n) {
        return m_debugLevel >= n;
    }

    static {
        try {
            Class<?> clazz = Class.forName("DebugLevel");
            Field field = clazz.getField("m_debugLevel");
            m_debugLevel = field.getInt(null);
            if (m_debugLevel != 0) {
                m_out.println("Debug level set to: " + m_debugLevel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

