/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.types;

import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;

public class STAttribute {
    protected int m_key;
    protected byte[] m_val = null;

    protected STAttribute() {
    }

    public STAttribute(int n, byte[] byArray) {
        this.m_key = n;
        this.m_val = byArray;
    }

    public STAttribute(int n, String string) {
        this.m_key = n;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeUTF(string);
            this.m_val = ndrOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public STAttribute(int n, int n2) {
        this.m_key = n;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeInt(n2);
            this.m_val = ndrOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public STAttribute(int n, long l) {
        this.m_key = n;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeLong(l);
            this.m_val = ndrOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public STAttribute(int n, boolean bl) {
        this.m_key = n;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeBoolean(bl);
            this.m_val = ndrOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public STAttribute(NdrInputStream ndrInputStream) throws IOException {
        this.load(ndrInputStream, true);
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        this.dump(ndrOutputStream, true);
    }

    public void dump(NdrOutputStream ndrOutputStream, boolean bl) throws IOException {
        ndrOutputStream.startMark();
        ndrOutputStream.writeInt(this.m_key);
        if (bl) {
            ndrOutputStream.writeBytes(this.m_val);
        } else {
            ndrOutputStream.writeBytes(new byte[0]);
        }
        ndrOutputStream.dumpMarks();
    }

    public void load(NdrInputStream ndrInputStream, boolean bl) throws IOException {
        ndrInputStream.loadMark();
        this.m_key = ndrInputStream.readInt();
        if (bl) {
            this.m_val = ndrInputStream.readBytes();
        }
        ndrInputStream.skipMarks();
    }

    public int getKey() {
        return this.m_key;
    }

    public byte[] getValue() {
        return this.m_val;
    }

    public int getInt() {
        int n = Integer.MIN_VALUE;
        try {
            if (null != this.m_val && this.m_val.length > 0) {
                NdrInputStream ndrInputStream = new NdrInputStream(this.m_val);
                n = ndrInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public long getLong() {
        long l = Long.MIN_VALUE;
        try {
            if (null != this.m_val && this.m_val.length > 0) {
                NdrInputStream ndrInputStream = new NdrInputStream(this.m_val);
                l = ndrInputStream.readLong();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return l;
    }

    public String getString() {
        String string = null;
        try {
            if (null != this.m_val && this.m_val.length > 0) {
                NdrInputStream ndrInputStream = new NdrInputStream(this.m_val);
                string = ndrInputStream.readUTF();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public boolean getBoolean() {
        boolean bl = false;
        try {
            if (null != this.m_val && this.m_val.length > 0) {
                NdrInputStream ndrInputStream = new NdrInputStream(this.m_val);
                bl = ndrInputStream.readBoolean();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public String toString() {
        return "key:" + this.m_key + " value:" + this.getString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof STAttribute && this.m_key == ((STAttribute)object).m_key) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.m_key;
    }

    public boolean isEmpty() {
        return this.m_val == null || this.m_val.length == 0;
    }
}

