/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TkLogFormatter
extends Formatter {
    private String m_lineSeparator = System.getProperty("line.separator");
    private boolean m_includeClassInfo = true;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("[MM/dd/yyyy HH:mm:ss]");
    private Date m_date = new Date();

    public TkLogFormatter() {
    }

    public TkLogFormatter(boolean bl, SimpleDateFormat simpleDateFormat) {
    }

    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.formatMessage(logRecord);
        stringBuffer.append(this.m_sdf.format(this.m_date));
        stringBuffer.append(' ');
        if (this.m_includeClassInfo) {
            stringBuffer.append("[");
            stringBuffer.append(logRecord.getSourceClassName());
            stringBuffer.append('.');
            stringBuffer.append(logRecord.getSourceMethodName());
            stringBuffer.append("] ");
        }
        this.m_date.setTime(System.currentTimeMillis());
        stringBuffer.append("::");
        stringBuffer.append(logRecord.getLevel().getLocalizedName());
        stringBuffer.append(":: ");
        stringBuffer.append("[ " + Thread.currentThread().getName() + " ]");
        stringBuffer.append(":: ");
        stringBuffer.append(string);
        stringBuffer.append(this.m_lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                stringBuffer.append(this.m_lineSeparator);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

