/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.comparch;

import com.lotus.sametime.core.comparch.InvokeEvent;
import com.lotus.sametime.core.comparch.MessageDispatcher;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STEventListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class Invoker {
    private MessageDispatcher m_dispatcher;
    private Hashtable m_delayedEvents = new Hashtable();
    private Thread m_invokeLaterThread;
    private static final String THREAD_NAME = "Zigfirid, the invoke later thread";

    Invoker(MessageDispatcher messageDispatcher) {
        this.m_dispatcher = messageDispatcher;
        this.m_dispatcher.addSTEventListener(new STEventListener(){

            public void processSTEvent(STEvent sTEvent) {
                Invoker.this.processSTEvent(sTEvent);
            }
        });
    }

    public void invokeLater(Runnable runnable) {
        this.m_dispatcher.sendEvent(new InvokeEvent(this, 0, runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable, long l) {
        long l2 = System.currentTimeMillis() + l;
        if (l2 < System.currentTimeMillis()) {
            this.invokeLater(runnable);
        } else {
            InvokeEvent invokeEvent = new InvokeEvent(this, 0, runnable, l2);
            this.m_delayedEvents.put(invokeEvent, invokeEvent);
            Invoker invoker = this;
            synchronized (invoker) {
                if (null == this.m_invokeLaterThread) {
                    this.m_invokeLaterThread = new Thread(THREAD_NAME){

                        public void run() {
                            Invoker.this.run();
                        }
                    };
                    this.m_invokeLaterThread.start();
                } else {
                    this.notify();
                }
            }
        }
    }

    void dispatchEvent(InvokeEvent invokeEvent) {
        this.m_dispatcher.sendEvent(invokeEvent);
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof InvokeEvent) {
            Runnable runnable = ((InvokeEvent)sTEvent).getRunnable();
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Invoker invoker;
        long l = Long.MAX_VALUE;
        while (this.m_delayedEvents.size() > 0) {
            Enumeration enumeration = ((Hashtable)this.m_delayedEvents.clone()).elements();
            while (enumeration.hasMoreElements()) {
                InvokeEvent invokeEvent = (InvokeEvent)enumeration.nextElement();
                if (invokeEvent.getTimeToInvoke() <= System.currentTimeMillis()) {
                    this.m_delayedEvents.remove(invokeEvent);
                    invokeEvent.getInvoker().dispatchEvent(invokeEvent);
                    continue;
                }
                if (invokeEvent.getTimeToInvoke() >= l) continue;
                l = invokeEvent.getTimeToInvoke();
            }
            if (this.m_delayedEvents.size() <= 0) continue;
            try {
                invoker = this;
                synchronized (invoker) {
                    long l2 = l - System.currentTimeMillis();
                    if (l2 > 0L) {
                        this.wait(l2);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        invoker = this;
        synchronized (invoker) {
            this.m_invokeLaterThread = null;
        }
    }
}

