/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.conf;

import com.lotus.sametime.core.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfInfo {
    public static final boolean CONF_PUBLIC = true;
    public static final boolean CONF_PRIVATE = false;
    public static final boolean CONF_SECURED = true;
    public static final boolean CONF_NON_SECURED = false;
    private String m_name;
    private String m_displayName;
    private boolean m_confTypePublic = false;
    private boolean m_confTypeSecured = false;
    private String m_dummy = "";
    private static Logger m_logger = Logger.getLogger("com.lotus.sametime.conf");

    public ConfInfo(String string, String string2) {
        this.m_name = string;
        this.m_displayName = string2;
    }

    static ConfInfo readConfInfo(DataInputStream dataInputStream) {
        try {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            boolean bl = dataInputStream.readBoolean();
            boolean bl2 = dataInputStream.readBoolean();
            String string3 = dataInputStream.readUTF();
            Debug.stAssert(string3.length() == 0);
            Debug.stAssert(!bl);
            Debug.stAssert(!bl2);
            return new ConfInfo(string, string2);
        }
        catch (IOException iOException) {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.logp(Level.FINER, ConfInfo.class.getName(), "readConfInfo", "ConfInfo:readConfInfo() IOException=" + iOException.getMessage());
            }
            iOException.printStackTrace();
            return null;
        }
    }

    void writeConfInfo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.m_name);
        dataOutputStream.writeUTF(this.m_displayName);
        dataOutputStream.writeBoolean(this.m_confTypePublic);
        dataOutputStream.writeBoolean(this.m_confTypeSecured);
        dataOutputStream.writeUTF(this.m_dummy);
    }

    public String toString() {
        return "ConfInfo[name=" + this.m_name + ", displayName=" + this.m_displayName + "]";
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }
}

