/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.enc.rc2_40;

import com.lotus.sametime.community.kernel.enc.EncData;
import com.lotus.sametime.community.kernel.enc.EncMethod;
import com.lotus.sametime.community.kernel.enc.EncParams;
import com.lotus.sametime.community.kernel.enc.rc2_40.EncParamsRc2_40;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EncMethodRc2_40
extends EncMethod {
    private static final int RC2_KEY_LENGTH = 40;
    private static final int RC2_KEY_BYTES = 5;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.community.kernel.enc.rc2_40");

    public EncParams newParams(EncData encData) {
        String string = encData.getCreatorId();
        byte[] byArray = this.keyFromString(string);
        EncParamsRc2_40 encParamsRc2_40 = new EncParamsRc2_40(this);
        encParamsRc2_40.getCipher().init(0, byArray);
        this.setEncError(0);
        return encParamsRc2_40;
    }

    public EncParams newParams(EncData encData, NdrInputStream ndrInputStream) {
        EncParamsRc2_40 encParamsRc2_40 = new EncParamsRc2_40(this);
        try {
            encParamsRc2_40.load(ndrInputStream);
        }
        catch (IOException iOException) {
            this.setEncError(3);
            return null;
        }
        String string = encData.getCreatorId();
        if (encData.getParamsList() != null) {
            string = encData.getAcceptorId();
        }
        byte[] byArray = this.keyFromString(string);
        encParamsRc2_40.getCipher().init(1, byArray);
        this.setEncError(0);
        return encParamsRc2_40;
    }

    public EncParams localizeParams(EncData encData, EncParams encParams, boolean bl) {
        if (bl) {
            return encParams;
        }
        String string = encData.getAcceptorId();
        byte[] byArray = this.keyFromString(string);
        EncParamsRc2_40 encParamsRc2_40 = new EncParamsRc2_40(this);
        encParamsRc2_40.getCipher().init(0, byArray);
        this.setEncError(0);
        return encParamsRc2_40;
    }

    public byte[] encrypt(byte[] byArray, EncData encData) {
        EncParamsRc2_40 encParamsRc2_40 = (EncParamsRc2_40)encData.getLocalParams();
        RC2Cipher rC2Cipher = encParamsRc2_40.getCipher();
        byte[] byArray2 = rC2Cipher.doFinal(byArray);
        this.setEncError(byArray2.length > 0 ? 0 : 3);
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray, EncData encData) {
        EncParamsRc2_40 encParamsRc2_40 = (EncParamsRc2_40)encData.getRemoteParams();
        RC2Cipher rC2Cipher = encParamsRc2_40.getCipher();
        byte[] byArray2 = rC2Cipher.doFinal(byArray);
        this.setEncError(byArray2.length > 0 ? 0 : 3);
        return byArray2;
    }

    public short getType() {
        return 0;
    }

    public EncLevel getLevel() {
        return EncLevel.ENC_LEVEL_RC2_40;
    }

    protected byte[] keyFromString(String string) {
        Object object;
        byte[] byArray;
        block3: {
            byArray = null;
            try {
                object = new NdrOutputStream();
                ((DataOutputStream)object).writeUTF(string);
                ((DataOutputStream)object).writeByte(0);
                ((DataOutputStream)object).writeInt(string.length());
                byArray = ((NdrOutputStream)object).toByteArray();
            }
            catch (IOException iOException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block3;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "keyFromString", "", iOException);
            }
        }
        object = new byte[5];
        for (int i = 0; i < 5; ++i) {
            object[i] = byArray[i + 2];
        }
        return object;
    }
}

