/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.enc;

import com.lotus.sametime.community.kernel.enc.EncData;
import com.lotus.sametime.community.kernel.enc.EncMethod;
import com.lotus.sametime.community.kernel.enc.EncMngr;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class EncParams {
    private EncMethod m_encMethod;

    protected EncParams(EncMethod encMethod) {
        this.m_encMethod = encMethod;
    }

    public EncMethod getEncMethod() {
        return this.m_encMethod;
    }

    protected void setEncMethod(EncMethod encMethod) {
        this.m_encMethod = encMethod;
    }

    public static void dumpEncParamList(Vector vector, NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeInt(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EncParams encParams = (EncParams)enumeration.nextElement();
            encParams.dump(ndrOutputStream);
        }
    }

    public static Vector loadEncParamList(EncData encData, NdrInputStream ndrInputStream) throws IOException {
        Vector<EncParams> vector = new Vector<EncParams>();
        int n = ndrInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            EncParams encParams = EncParams.loadParams(encData, ndrInputStream);
            if (encParams == null) continue;
            vector.addElement(encParams);
        }
        return vector;
    }

    public static EncParams loadParams(EncData encData, NdrInputStream ndrInputStream) throws IOException {
        short s = ndrInputStream.readShort();
        EncMethod encMethod = EncMngr.getEncMethod(s);
        if (encMethod == null) {
            int n = ndrInputStream.readInt();
            ndrInputStream.skipBytes(n);
            return null;
        }
        EncParams encParams = encMethod.newParams(encData, ndrInputStream);
        return encParams;
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeShort(this.m_encMethod.getType());
    }
}

