/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.enc;

import com.lotus.sametime.community.kernel.enc.EncMethod;
import com.lotus.sametime.community.kernel.enc.EncParams;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Vector;

public class EncData {
    private static final short FORCE_ENCRYPTION_MASK = Short.MIN_VALUE;
    private EncLevel m_encLevel = EncLevel.ENC_LEVEL_NONE;
    private Vector m_paramsList = null;
    private EncParams m_localParams = null;
    private EncParams m_remoteParams = null;
    private NdrInputStream m_dataStream = null;
    private String m_creatorId;
    private String m_acceptorId;
    private EncLevel m_minAgreedLevel = this.m_encLevel;
    private boolean m_isEncryptionForced = false;

    public EncData(EncLevel encLevel) {
        this.m_minAgreedLevel = this.m_encLevel = encLevel;
    }

    public EncLevel getEncLevel() {
        return this.m_encLevel;
    }

    public void setEncLevel(EncLevel encLevel) {
        this.m_encLevel = encLevel;
    }

    public Vector getParamsList() {
        return this.m_paramsList;
    }

    public void setParamsList(Vector vector) {
        this.m_paramsList = vector;
    }

    public EncParams getRemoteParams() {
        return this.m_remoteParams;
    }

    public void setRemoteParams(EncParams encParams) {
        this.m_remoteParams = encParams;
    }

    public EncParams getLocalParams() {
        return this.m_localParams;
    }

    public void setLocalParams(EncParams encParams) {
        this.m_localParams = encParams;
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        this.m_encLevel.dump(ndrOutputStream);
        if (this.m_encLevel.isEqual(EncLevel.ENC_LEVEL_NONE)) {
            return;
        }
        NdrOutputStream ndrOutputStream2 = new NdrOutputStream();
        if (this.m_remoteParams != null) {
            this.m_localParams.dump(ndrOutputStream2);
        } else {
            EncParams.dumpEncParamList(this.m_paramsList, ndrOutputStream2);
        }
        this.m_minAgreedLevel.dump(ndrOutputStream2);
        ndrOutputStream2.writeBoolean(this.m_isEncryptionForced);
        ndrOutputStream.writeBytes(ndrOutputStream2.toByteArray());
    }

    public void load(NdrInputStream ndrInputStream) throws IOException {
        short s = ndrInputStream.readShort();
        if ((s & Short.MIN_VALUE) != 0) {
            this.m_isEncryptionForced = true;
            s = (short)(s & Short.MAX_VALUE);
        }
        this.m_encLevel = new EncLevel(s);
        if (this.m_encLevel.isEqual(EncLevel.ENC_LEVEL_NONE)) {
            return;
        }
        this.m_dataStream = new NdrInputStream(ndrInputStream.readBytes());
    }

    protected void readParamsList() throws IOException {
        this.m_paramsList = EncParams.loadEncParamList(this, this.m_dataStream);
    }

    protected void readRemoteParams() throws IOException {
        this.m_remoteParams = EncParams.loadParams(this, this.m_dataStream);
    }

    protected void readMinLevelAndForceFlag() throws IOException {
        this.m_minAgreedLevel = new EncLevel(this.m_dataStream);
        this.m_isEncryptionForced |= this.m_dataStream.readBoolean();
    }

    public boolean isEncrypted() {
        return !this.m_encLevel.isEqual(EncLevel.ENC_LEVEL_NONE);
    }

    public EncLevel remoteEncLevel() {
        if (this.m_remoteParams == null) {
            return this.m_encLevel;
        }
        EncMethod encMethod = this.m_remoteParams.getEncMethod();
        return encMethod == null ? this.m_encLevel : encMethod.getLevel();
    }

    public void setCreatorId(String string) {
        this.m_creatorId = string;
    }

    public String getCreatorId() {
        return this.m_creatorId;
    }

    public void setAcceptorId(String string) {
        this.m_acceptorId = string;
    }

    public String getAcceptorId() {
        return this.m_acceptorId;
    }

    public EncLevel getMinAgreedLevel() {
        return this.m_minAgreedLevel;
    }

    void setMinAgreedLevel(EncLevel encLevel) {
        this.m_minAgreedLevel = encLevel;
    }

    public boolean isEncryptionForced() {
        return this.m_isEncryptionForced;
    }

    void setEncryptionForced(boolean bl) {
        bl = this.m_isEncryptionForced;
    }
}

