/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel;

import com.lotus.sametime.community.kernel.VpkAuthInfo;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.enc.DiffieHellman;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.IOException;
import java.util.Random;

public class VpkDiffieAuthInfo
extends VpkAuthInfo {
    private static final int RC2_KEY_LENGTH = 16;
    DiffieHellman m_keyGenerator;
    byte[] m_privateKey;
    byte[] m_agreedKey;
    byte[] m_challenge;

    public VpkDiffieAuthInfo(short s, byte[] byArray, byte[] byArray2, byte[] byArray3, Random random) {
        super(s, byArray);
        Debug.stAssert(s == 5 || s == 4);
        this.m_challenge = byArray3;
        this.m_keyGenerator = new DiffieHellman(DiffieHellman.Default_Modulus, DiffieHellman.Default_Base);
        this.m_privateKey = this.m_keyGenerator.generatePrivateKey(random);
        this.m_agreedKey = this.m_keyGenerator.generateAgreedValue(this.m_privateKey, byArray2);
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        byte[] byArray = this.encryptData();
        ndrOutputStream.writeBytes(byArray);
        ndrOutputStream.writeShort(this.getType());
    }

    private byte[] encryptData() {
        byte[] byArray = this.getData();
        byte[] byArray2 = new byte[byArray.length + this.m_challenge.length];
        System.arraycopy(this.m_challenge, 0, byArray2, 0, this.m_challenge.length);
        System.arraycopy(byArray, 0, byArray2, this.m_challenge.length, byArray.length);
        byte[] byArray3 = RC2Cipher.encryptOT(byArray2, this.m_agreedKey, 16);
        byte[] byArray4 = this.m_keyGenerator.generatePublicKey(this.m_privateKey);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeShort(1);
            ndrOutputStream.writeBytes(byArray4);
            ndrOutputStream.writeBytes(byArray3);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        return ndrOutputStream.toByteArray();
    }

    byte[] getAgreedKey() {
        return this.m_agreedKey;
    }
}

