/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.conf;

import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.ChatUIComp;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.conf.ConfModel;
import com.lotus.sametime.chatui.conf.ConfModelListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.conf.ConfInfo;
import com.lotus.sametime.conf.ConfListener;
import com.lotus.sametime.conf.ConfService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.names.NamesEvent;
import com.lotus.sametime.names.NamesService;
import com.lotus.sametime.names.NamesServiceListener;
import com.lotus.sametime.places.Place;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConfModelImpl
implements ConfModel,
ConfListener,
LoginListener,
NamesServiceListener {
    private static final int RESPONSE_DATA_TYPE = 1;
    private static final int RESPONSE_STARTED_DATA_SUB_TYPE = 0;
    private static final int RESPONSE_CLEARED_DATA_SUB_TYPE = 0;
    private STSession m_session;
    private CommunityService m_commService;
    private ConfService m_confService;
    private NamesService m_namesService;
    private ChatUIComp m_chat;
    private Integer m_confId;
    private MeetingInfo m_confInfo;
    private Vector m_peopleToInvite = new Vector();
    private Vector m_peopleToAutoInvInvite = new Vector();
    private String m_invitation;
    private Hashtable m_peopleList = new Hashtable();
    private STUserInstance m_myUserInstance = null;
    private Vector m_Listeners = new Vector();
    private Vector m_messagesList;
    private boolean m_isEncrypted = false;
    private boolean m_isViewEnabled = true;
    private boolean m_inInvitation = false;
    private boolean m_confCreated = true;

    public ConfModelImpl(STSession sTSession, String string, EncLevel encLevel, STUser[] sTUserArray, String string2) {
        this.m_session = sTSession;
        this.m_isEncrypted = !encLevel.isLower(EncLevel.ENC_LEVEL_ALL);
        this.m_confService = (ConfService)sTSession.getCompApi("com.lotus.sametime.conf.ConfComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
        this.m_chat = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_confService.addConfListener(this);
        this.m_commService.addLoginListener(this);
        this.m_namesService = (NamesService)sTSession.getCompApi("com.lotus.sametime.names.NamesComp");
        if (this.m_namesService != null) {
            this.m_namesService.addNamesServiceListener(this);
        }
        this.addToInvitation(sTUserArray);
        this.m_invitation = string2;
        this.m_confCreated = false;
        String string3 = string + new Date();
        this.m_confId = this.m_confService.createConference(new ConfInfo(string3, string), encLevel);
        String string4 = this.m_myUserInstance.getCommunityName();
        this.m_confInfo = new MeetingInfo(MeetingTypes.ST_CHAT_MEETING, string3, string, encLevel, string4, this.m_confId);
        if (this.m_chat.getSaveTranscriptMode()) {
            this.m_messagesList = new Vector(50);
        }
    }

    public ConfModelImpl(STSession sTSession, MeetingInfo meetingInfo) {
        this(sTSession, meetingInfo, false);
    }

    public ConfModelImpl(STSession sTSession, MeetingInfo meetingInfo, boolean bl) {
        this.m_session = sTSession;
        this.m_confInfo = meetingInfo;
        EncLevel encLevel = this.m_confInfo.getEncLevel();
        this.m_isEncrypted = !encLevel.isLower(EncLevel.ENC_LEVEL_ALL);
        this.m_confCreated = true;
        this.m_confService = (ConfService)sTSession.getCompApi("com.lotus.sametime.conf.ConfComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
        this.m_chat = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_confService.addConfListener(this);
        this.m_commService.addLoginListener(this);
        this.m_confId = meetingInfo.getConfId();
        this.m_inInvitation = bl;
        if (this.m_chat.getSaveTranscriptMode()) {
            this.m_messagesList = new Vector(50);
        }
    }

    public synchronized void addConfModelListener(ConfModelListener confModelListener) {
        Vector vector = (Vector)this.m_Listeners.clone();
        vector.addElement(confModelListener);
        this.m_Listeners = vector;
    }

    public synchronized void removeConfModelListener(ConfModelListener confModelListener) {
        Vector vector = (Vector)this.m_Listeners.clone();
        vector.removeElement(confModelListener);
        this.m_Listeners = vector;
    }

    public void sendMessage(String string) {
        if (this.m_confId != null) {
            this.m_confService.sendText(this.m_confId, true, string);
        }
    }

    public void sendResponseStarted() {
        if (this.m_confId != null) {
            this.m_confService.sendData(this.m_confId, false, 1, 0, null);
        }
    }

    public void sendResponseCleared() {
        if (this.m_confId != null) {
            this.m_confService.sendData(this.m_confId, false, 1, 0, null);
        }
    }

    public synchronized void inviteToConference(STUser[] sTUserArray, String string) {
        if (this.m_confCreated) {
            for (int i = 0; i < sTUserArray.length; ++i) {
                if (this.m_peopleList.contains(sTUserArray[i])) continue;
                this.m_confService.inviteToConference(this.m_confId, sTUserArray[i].getId(), sTUserArray[i].getName(), null, string);
            }
        } else {
            this.addToInvitation(sTUserArray);
        }
    }

    public synchronized void autoInviteToConference(STUser sTUser) {
        if (this.m_confCreated) {
            this.m_confService.autoInviteToConference(this.m_confId, sTUser.getId(), sTUser.getName(), null, "");
        } else {
            this.m_peopleToAutoInvInvite.addElement(sTUser);
        }
    }

    public void closeChat() {
        this.m_confService.removeConfListener(this);
        this.m_confService.destroyConference(this.m_confId);
        if (null != this.m_namesService) {
            this.m_namesService.removeNamesServiceListener(this);
        }
        this.m_commService.removeLoginListener(this);
        this.requestShowView(false);
        this.m_confId = null;
    }

    public MeetingInfo getConfInfo() {
        return this.m_confInfo;
    }

    public Place getPlace() {
        return null;
    }

    public STSession getSession() {
        return this.m_session;
    }

    public synchronized STUser[] getPeople() {
        STUser[] sTUserArray = new STUser[this.m_peopleList.size()];
        Enumeration enumeration = this.m_peopleList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            sTUserArray[n] = (STUser)enumeration.nextElement();
            ++n;
        }
        return sTUserArray;
    }

    public boolean isEncrypted() {
        return this.m_isEncrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatMessage[] getChatTranscript() {
        Object[] objectArray = null;
        if (null != this.m_messagesList) {
            Vector vector = this.m_messagesList;
            synchronized (vector) {
                objectArray = new ChatMessage[this.m_messagesList.size()];
                this.m_messagesList.copyInto(objectArray);
            }
        } else {
            objectArray = new ChatMessage[]{};
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTranscript(ChatMessage[] chatMessageArray) {
        if (null != this.m_messagesList) {
            Vector vector = this.m_messagesList;
            synchronized (vector) {
                for (int i = 0; i < chatMessageArray.length; ++i) {
                    this.m_messagesList.addElement(chatMessageArray[i]);
                }
            }
        }
    }

    public void acceptInvitation() {
        Debug.stAssert(this.m_inInvitation);
        this.m_confService.joinToConference(this.m_confId);
        this.requestShowView(true);
        this.m_inInvitation = false;
    }

    public void declineInvitation() {
        Debug.stAssert(this.m_inInvitation);
        this.m_confService.declineInvitation(this.m_confId, 0);
        this.m_inInvitation = false;
    }

    public void requestShowView(boolean bl) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.setVisible(bl);
        }
    }

    public void requestToFront() {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conferenceCreated(Integer n, ConfInfo confInfo, EncLevel encLevel, STUserInstance[] sTUserInstanceArray) {
        if (!n.equals(this.m_confId)) {
            return;
        }
        String string = this.m_myUserInstance.getCommunityName();
        this.m_confInfo = new MeetingInfo(MeetingTypes.ST_CHAT_MEETING, confInfo.getName(), confInfo.getDisplayName(), encLevel, string, n);
        this.requestShowView(true);
        this.m_isEncrypted = !encLevel.isLower(EncLevel.ENC_LEVEL_ALL);
        this.encryptionModeChanged(this.m_isEncrypted);
        this.enableSendMessage(true);
        if (sTUserInstanceArray != null) {
            for (int i = 0; i < sTUserInstanceArray.length; ++i) {
                this.userEntered(this.m_confId, sTUserInstanceArray[i]);
            }
        }
        ConfModelImpl confModelImpl = this;
        synchronized (confModelImpl) {
            this.m_confCreated = true;
            if (!this.m_peopleToInvite.isEmpty()) {
                STUser[] sTUserArray = new STUser[this.m_peopleToInvite.size()];
                for (int i = 0; i < sTUserArray.length; ++i) {
                    sTUserArray[i] = (STUser)this.m_peopleToInvite.elementAt(i);
                }
                this.inviteToConference(sTUserArray, this.m_invitation);
                this.m_peopleToInvite.removeAllElements();
            }
            if (!this.m_peopleToAutoInvInvite.isEmpty()) {
                for (int i = 0; i < this.m_peopleToAutoInvInvite.size(); ++i) {
                    STUser sTUser = (STUser)this.m_peopleToAutoInvInvite.elementAt(i);
                    this.autoInviteToConference(sTUser);
                }
                this.m_peopleToInvite.removeAllElements();
            }
        }
    }

    public void conferenceDenied(Integer n, int n2) {
        if (!n.equals(this.m_confId)) {
            return;
        }
        this.m_confId = null;
        this.sendFailed(n2);
        this.enableSendMessage(false);
    }

    public void conferenceDestroyed(Integer n, int n2) {
        if (!n.equals(this.m_confId)) {
            return;
        }
        this.m_confId = null;
        if (n2 != 0) {
            this.sendFailed(n2);
        }
        this.enableSendMessage(false);
    }

    public synchronized void userEntered(Integer n, STUserInstance sTUserInstance) {
        if (!n.equals(this.m_confId)) {
            return;
        }
        STLoginId sTLoginId = sTUserInstance.getLoginId();
        if (null != this.m_namesService) {
            sTUserInstance.setNickName(this.m_namesService.getNickname(sTUserInstance));
            sTUserInstance.setNameDelimiter(this.m_namesService.getNameDelimiter());
        }
        this.m_peopleList.put(sTLoginId, sTUserInstance);
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.userEntered(sTUserInstance);
        }
    }

    public synchronized void userLeft(Integer n, STLoginId sTLoginId) {
        if (!n.equals(this.m_confId)) {
            return;
        }
        STUser sTUser = (STUser)this.m_peopleList.remove(sTLoginId);
        Debug.stAssert(sTUser != null);
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.userLeft(sTUser);
        }
    }

    public void textReceived(Integer n, boolean bl, STLoginId sTLoginId, String string) {
        if (!n.equals(this.m_confId)) {
            return;
        }
        STUser sTUser = (STUser)this.m_peopleList.get(sTLoginId);
        boolean bl2 = sTLoginId.equals(this.m_myUserInstance.getLoginId());
        ChatMessage chatMessage = new ChatMessage(sTUser, string, bl2);
        Enumeration enumeration = this.m_Listeners.elements();
        if (null != this.m_messagesList) {
            this.m_messagesList.addElement(chatMessage);
        }
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.messageReceived(chatMessage);
        }
    }

    public void dataReceived(Integer n, boolean bl, STLoginId sTLoginId, int n2, int n3, byte[] byArray) {
        if (n.equals(this.m_confId) && n2 == 1 && !sTLoginId.equals(this.m_myUserInstance.getLoginId())) {
            boolean bl2;
            Enumeration enumeration = this.m_Listeners.elements();
            STUser sTUser = (STUser)this.m_peopleList.get(sTLoginId);
            boolean bl3 = bl2 = n3 == 0;
            while (enumeration.hasMoreElements()) {
                ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
                if (bl2) {
                    confModelListener.responseStarted(sTUser);
                    continue;
                }
                confModelListener.responseCleared(sTUser);
            }
        }
    }

    public void conferenceIntruded(Integer n, STUserInstance sTUserInstance, short s) {
    }

    public void serviceAvailable() {
    }

    public void serviceUnavailable() {
    }

    public void invitationDeclined(Integer n, STUserInstance sTUserInstance, int n2) {
        if (n.equals(this.m_confId)) {
            Enumeration enumeration = this.m_Listeners.elements();
            STUserInstance sTUserInstance2 = sTUserInstance;
            while (enumeration.hasMoreElements()) {
                ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
                confModelListener.invitationDeclined(sTUserInstance2, n2);
            }
        }
    }

    public void invitedToConference(Integer n, ConfInfo confInfo, STUserInstance sTUserInstance, EncLevel encLevel, boolean bl, String string) {
    }

    public void loggedIn(LoginEvent loginEvent) {
        STId sTId = this.m_myUserInstance.getId();
        STId sTId2 = this.m_commService.getLogin().getMyUserInstance().getId();
        if (!sTId2.equals(sTId)) {
            this.closeChat();
        }
        this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.enableSendMessage(false);
    }

    protected void enableSendMessage(boolean bl) {
        this.m_isViewEnabled = bl;
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.enableSendMessage(bl);
        }
    }

    public void upgradeToMeeting(Vector vector, boolean bl) {
    }

    protected void sendFailed(int n) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.sendFailed(n);
        }
    }

    protected void encryptionModeChanged(boolean bl) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.encryptionModeChanged(bl);
        }
    }

    protected void addToInvitation(STUser[] sTUserArray) {
        for (int i = 0; i < sTUserArray.length; ++i) {
            this.m_peopleToInvite.addElement(sTUserArray[i]);
        }
    }

    public void nameChanged(NamesEvent namesEvent) {
        Hashtable hashtable = (Hashtable)this.m_peopleList.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            STUser sTUser = (STUser)enumeration.nextElement();
            if (!sTUser.getId().equals(namesEvent.getUser().getId())) continue;
            sTUser.setNickName(namesEvent.getUser().getNickName());
            break;
        }
    }

    public void nameDelimiterChanged(NamesEvent namesEvent) {
        Hashtable hashtable = (Hashtable)this.m_peopleList.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            STUser sTUser = (STUser)enumeration.nextElement();
            sTUser.setNameDelimiter(namesEvent.getNameDelimiter());
        }
    }

    public boolean isAudioEnabled() {
        return this.m_chat.isAudioEnabled();
    }

    public boolean isAudioBridgeEnabled() {
        return this.m_chat.isAudioBridgeEnabled();
    }

    public boolean isVideoEnabled() {
        return this.m_chat.isAudioEnabled();
    }

    public boolean isMeetingEnabled() {
        return this.m_chat.isMeetingEnabled();
    }

    public boolean isViewEnabled() {
        return this.m_isViewEnabled;
    }
}

