/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.conf;

import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.ChatController;
import com.lotus.sametime.chatui.AddToListListener;
import com.lotus.sametime.chatui.ChatFactory;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class ConfController
extends ChatController {
    private MenuItem m_addToList;
    private MenuItem m_editNickname;
    private ChatFactory m_factory;
    private STBundle m_res;

    public ConfController(STSession sTSession, AwarenessModel awarenessModel) {
        super(awarenessModel);
        ChatUI chatUI = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_factory = chatUI.getChatFactory();
    }

    protected void createMenuItems() {
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)this.m_model.getSession().getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_res = resourceLoaderService.getBundle("properties/chatui");
        this.m_addToList = new MenuItem(this.m_res.getString("MENUITEM_ADD_TO_LIST"));
        this.m_editNickname = new MenuItem(this.m_res.getString("MENU_EDIT"));
        super.createMenuItems();
    }

    public void enablePopupItems(Vector vector) {
        boolean bl = false;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)object.nextElement();
            if (awarenessNode.isOnline()) continue;
            bl = true;
            break;
        }
        this.m_popup.removeAll();
        this.m_popup.add(this.m_message);
        if (this.m_phoneServiceId != null) {
            this.m_popup.add(this.m_startPhoneCall);
            this.m_startPhoneCall.setEnabled(vector.size() > 0);
        }
        if ((object = this.m_factory.getAddToListListener()) != null) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_editNickname);
            this.m_popup.add(this.m_addToList);
        }
        if (this.m_deleteEnabled) {
            this.m_popup.add(this.m_separator);
            this.m_popup.add(this.m_remove);
        }
        this.m_message.setEnabled(!bl && this.m_messageEnabled);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_popup) {
            String string = actionEvent.getActionCommand();
            if (string == this.m_res.getString("MENUITEM_ADD_TO_LIST")) {
                STUser[] sTUserArray = this.m_model.getUsersFromNodes(this.m_selectedNodes);
                this.handleAddToList(sTUserArray);
            } else if (string == this.m_res.getString("MENU_EDIT")) {
                STUser[] sTUserArray = this.m_model.getUsersFromNodes(this.m_selectedNodes);
                this.handleEditNickname(sTUserArray);
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected void handleAddToList(STUser[] sTUserArray) {
        AddToListListener addToListListener = this.m_factory.getAddToListListener();
        if (addToListListener != null) {
            addToListListener.addToList(sTUserArray);
        }
    }

    protected void handleEditNickname(STUser[] sTUserArray) {
        AddToListListener addToListListener = this.m_factory.getAddToListListener();
        if (addToListListener != null) {
            addToListListener.editNickname(sTUserArray[0]);
        }
    }
}

