/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;

public class MeetingInfo {
    MeetingTypes m_meetingType;
    String m_displayName;
    EncLevel m_encLevel;
    String m_placeName;
    String m_password;
    String m_serverName;
    String m_meetingURL = "";
    int m_sslPort;
    boolean m_is1on1;
    Integer m_confId;
    boolean m_hasChat;
    boolean m_isRecorded;

    public MeetingInfo(MeetingTypes meetingTypes, String string, EncLevel encLevel, String string2, String string3, String string4) {
        this(meetingTypes, string, encLevel, string2, string3, string4, 0, "");
    }

    public MeetingInfo(MeetingTypes meetingTypes, String string, EncLevel encLevel, String string2, String string3, String string4, int n, String string5, boolean bl) {
        this.m_meetingType = meetingTypes;
        this.m_displayName = string;
        this.m_encLevel = encLevel;
        this.m_placeName = string2;
        this.m_password = string3;
        this.m_serverName = string4;
        this.m_sslPort = n;
        this.m_meetingURL = string5;
        this.m_isRecorded = bl;
    }

    public MeetingInfo(MeetingTypes meetingTypes, String string, EncLevel encLevel, String string2, String string3, String string4, int n, String string5) {
        this.m_meetingType = meetingTypes;
        this.m_displayName = string;
        this.m_encLevel = encLevel;
        this.m_placeName = string2;
        this.m_password = string3;
        this.m_serverName = string4;
        this.m_sslPort = n;
        this.m_meetingURL = string5;
    }

    public MeetingInfo(MeetingTypes meetingTypes, String string, String string2, EncLevel encLevel, String string3, Integer n) {
        this.m_meetingType = meetingTypes;
        this.m_placeName = string;
        this.m_displayName = string2;
        this.m_encLevel = encLevel;
        this.m_serverName = string3;
        this.m_confId = n;
        this.m_sslPort = 0;
    }

    public MeetingInfo(NdrInputStream ndrInputStream) throws IOException {
        this.load(ndrInputStream);
    }

    public void load(NdrInputStream ndrInputStream) throws IOException {
        this.m_meetingType = new MeetingTypes(ndrInputStream);
        this.m_is1on1 = ndrInputStream.readBoolean();
        short s = ndrInputStream.readShort();
        this.m_encLevel = s == 0 ? EncLevel.ENC_LEVEL_NONE : EncLevel.ENC_LEVEL_RC2_40;
        this.m_placeName = ndrInputStream.readUTF();
        this.m_password = ndrInputStream.readUTF();
        this.m_serverName = ndrInputStream.readUTF();
    }

    public void dump(NdrOutputStream ndrOutputStream, boolean bl) throws IOException {
        this.m_meetingType.dump(ndrOutputStream);
        ndrOutputStream.writeBoolean(bl);
        this.m_encLevel.dump(ndrOutputStream);
        ndrOutputStream.writeUTF(this.m_placeName);
        ndrOutputStream.writeUTF(this.m_password);
        ndrOutputStream.writeUTF(this.m_serverName);
    }

    public MeetingTypes getType() {
        return this.m_meetingType;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String string) {
        this.m_displayName = string;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public void setServerName(String string) {
        this.m_serverName = string;
    }

    public String getName() {
        String string = this.getPlaceName();
        if (string == null || string.equalsIgnoreCase("")) {
            return this.getDisplayName();
        }
        return string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public EncLevel getEncLevel() {
        return this.m_encLevel;
    }

    public boolean is1on1() {
        return this.m_is1on1 && this.m_meetingType != MeetingTypes.ST_CHAT_MEETING;
    }

    public Integer getConfId() {
        return this.m_confId;
    }

    public int getSSLPort() {
        return this.m_sslPort;
    }

    public void setSSLPort(int n) {
        this.m_sslPort = n;
    }

    public String getURL() {
        return this.m_meetingURL;
    }

    public void setURL(String string) {
        this.m_meetingURL = string;
    }

    void setHasChat(boolean bl) {
        this.m_hasChat = bl;
    }

    public boolean hasChat() {
        return this.m_hasChat;
    }

    void setIsRecorded(boolean bl) {
        this.m_hasChat = bl;
    }

    public boolean isRecorded() {
        return this.m_isRecorded;
    }
}

