/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.ChatModelListener;
import com.lotus.sametime.chatui.ChatUIComp;
import com.lotus.sametime.chatui.MeetingHandler;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.conf.ConfModel;
import com.lotus.sametime.chatui.conf.ConfModelImpl;
import com.lotus.sametime.chatui.conf.ConfModelListener;
import com.lotus.sametime.chatui.conf.PlacesModelImpl;
import com.lotus.sametime.chatui.im.ImModel;
import com.lotus.sametime.chatui.im.ImModelAdapter;
import com.lotus.sametime.chatui.im.ImModelImpl;
import com.lotus.sametime.chatui.im.ImModelListener;
import com.lotus.sametime.chatui.invitation.Invitation;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.places.Place;
import java.util.Enumeration;
import java.util.Vector;

public class ChatModel
implements ImModel,
ConfModel {
    private ChatUIComp m_ChatUIComp;
    private ImModelImpl m_ImModel = null;
    private ConfModel m_confModel = null;
    private boolean m_isInConfMode = false;
    private ImModelListenerImp m_imModelListener;
    private Vector m_Listeners = new Vector();
    private boolean m_watsonServer;

    protected static ChatModel getImModel(STSession sTSession, STUser sTUser, Im im, boolean bl) {
        ChatUIComp chatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        ChatModel chatModel = chatUIComp.getImModel(sTUser.getId());
        if (chatModel == null) {
            chatModel = new ChatModel(sTSession, sTUser, im, bl);
        }
        return chatModel;
    }

    protected ChatModel(STSession sTSession, String string, EncLevel encLevel, STUser[] sTUserArray, String string2) {
        this.m_isInConfMode = true;
        this.m_watsonServer = this.isWatsonServer(sTSession);
        this.m_confModel = this.m_watsonServer ? new PlacesModelImpl(sTSession, string, encLevel, sTUserArray, string2) : new ConfModelImpl(sTSession, string, encLevel, sTUserArray, string2);
        this.m_ChatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_ChatUIComp.addModel(this);
    }

    public ChatModel(STSession sTSession, Invitation invitation) {
        this.m_isInConfMode = true;
        this.m_watsonServer = this.isWatsonServer(sTSession);
        boolean bl = invitation.getType() == 2;
        this.m_confModel = bl ? new PlacesModelImpl(sTSession, invitation) : new ConfModelImpl(sTSession, invitation.getMeetingInfo(), true);
        this.m_ChatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_ChatUIComp.addModel(this);
    }

    private ChatModel(STSession sTSession, STUser sTUser, Im im, boolean bl) {
        this.m_ChatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_watsonServer = this.isWatsonServer(sTSession);
        this.m_isInConfMode = false;
        this.m_ImModel = new ImModelImpl(sTSession, sTUser, im, bl, this.m_ChatUIComp.getSaveTranscriptMode());
        this.m_imModelListener = new ImModelListenerImp();
        this.m_ImModel.addImModelListener(this.m_imModelListener);
        this.m_ChatUIComp.addModel(this);
        this.m_ImModel.init();
    }

    public void addChatModelListener(ChatModelListener chatModelListener) {
        this.m_Listeners.addElement(chatModelListener);
    }

    public void removeChatModelListener(ChatModelListener chatModelListener) {
        this.m_Listeners.removeElement(chatModelListener);
    }

    public void switchToConference(STSession sTSession, String string, EncLevel encLevel, STUser[] sTUserArray, String string2) {
        Debug.stAssert(!this.m_isInConfMode);
        this.m_ChatUIComp.modelSwitchedToConference(this, string);
        boolean bl = this.m_ImModel.isOmActive();
        ChatMessage[] chatMessageArray = this.m_ImModel.getChatTranscript();
        this.m_ImModel.closeChat(false, false);
        STUser sTUser = this.m_ImModel.getPartner();
        sTUserArray = this.removeFromUserList(sTUser, sTUserArray);
        this.m_ImModel.removeImModelListener(this.m_imModelListener);
        this.m_ImModel = null;
        this.m_isInConfMode = true;
        this.m_confModel = this.m_watsonServer ? new PlacesModelImpl(sTSession, string, encLevel, sTUserArray, string2) : new ConfModelImpl(sTSession, string, encLevel, sTUserArray, string2);
        this.m_confModel.addToTranscript(chatMessageArray);
        if (bl) {
            this.m_confModel.autoInviteToConference(sTUser);
        } else {
            STUser[] sTUserArray2 = new STUser[]{sTUser};
            this.m_confModel.inviteToConference(sTUserArray2, string2);
        }
        this.notifySwitchToConference();
    }

    public void switchToConference(STSession sTSession, MeetingInfo meetingInfo, boolean bl) {
        Debug.stAssert(!this.m_isInConfMode);
        this.m_ChatUIComp.modelSwitchedToConference(this, meetingInfo.getName());
        ChatMessage[] chatMessageArray = this.m_ImModel.getChatTranscript();
        this.m_ImModel.closeChat(false, false);
        this.m_ImModel.removeImModelListener(this.m_imModelListener);
        this.m_ImModel = null;
        this.m_isInConfMode = true;
        this.m_confModel = bl ? new PlacesModelImpl(sTSession, meetingInfo) : new ConfModelImpl(sTSession, meetingInfo);
        this.m_confModel.addToTranscript(chatMessageArray);
        this.notifySwitchToConference();
    }

    public void upgradeToMeeting(Vector vector, boolean bl) {
        if (this.m_ImModel != null) {
            this.m_ImModel.upgradeToMeeting(vector, bl);
            this.m_ChatUIComp.removeModel(this);
            this.m_ImModel.closeChat(false, true);
        } else {
            this.m_confModel.upgradeToMeeting(vector, bl);
        }
    }

    public void upgradeToMeeting(MeetingInfo meetingInfo) {
        this.notifySwitchToMeeting(meetingInfo);
        if (this.m_ImModel != null) {
            new MeetingHandler(meetingInfo, this.getSession(), this.m_ImModel.getChatTranscript());
            this.m_ChatUIComp.removeModel(this);
            this.m_ImModel.closeChat(false, true);
        }
    }

    public boolean isPartnerId(STId sTId) {
        STUserInstance sTUserInstance;
        STLoginId sTLoginId;
        STUser sTUser;
        return this.m_ImModel != null && (sTUser = this.m_ImModel.getPartner()) instanceof STUserInstance && (sTLoginId = (sTUserInstance = (STUserInstance)sTUser).getLoginId()).equals(sTId);
    }

    public boolean isInConfMode() {
        return this.m_isInConfMode;
    }

    public boolean isPlacesModel() {
        return null != this.m_confModel && this.m_confModel instanceof PlacesModelImpl;
    }

    public void addImModelListener(ImModelListener imModelListener) {
        if (this.m_ImModel != null) {
            this.m_ImModel.addImModelListener(imModelListener);
        }
    }

    public void removeImModelListener(ImModelListener imModelListener) {
        if (this.m_ImModel != null) {
            this.m_ImModel.removeImModelListener(imModelListener);
        }
    }

    public void sendMessage(String string) {
        if (this.m_ImModel != null) {
            this.m_ImModel.sendMessage(string);
        } else {
            this.m_confModel.sendMessage(string);
        }
    }

    public void sendResponseStarted() {
        if (this.m_ImModel != null) {
            this.m_ImModel.sendResponseStarted();
        } else {
            this.m_confModel.sendResponseStarted();
        }
    }

    public void sendResponseCleared() {
        if (this.m_ImModel != null) {
            this.m_ImModel.sendResponseCleared();
        } else {
            this.m_confModel.sendResponseCleared();
        }
    }

    public void closeChat() {
        this.m_ChatUIComp.removeModel(this);
        if (this.m_ImModel != null) {
            this.m_ImModel.closeChat();
        } else {
            this.m_confModel.closeChat();
        }
    }

    public ChatMessage[] getChatTranscript() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.getChatTranscript();
        }
        return this.m_confModel.getChatTranscript();
    }

    public void addToTranscript(ChatMessage[] chatMessageArray) {
        if (this.m_ImModel != null) {
            Debug.stAssert(false);
        } else {
            this.m_confModel.addToTranscript(chatMessageArray);
        }
    }

    public void addConfModelListener(ConfModelListener confModelListener) {
        if (this.m_confModel != null) {
            this.m_confModel.addConfModelListener(confModelListener);
        }
    }

    public void removeConfModelListener(ConfModelListener confModelListener) {
        if (this.m_confModel != null) {
            this.m_confModel.removeConfModelListener(confModelListener);
        }
    }

    public void autoInviteToConference(STUser sTUser) {
        if (this.m_confModel != null) {
            this.m_confModel.autoInviteToConference(sTUser);
        }
    }

    public void inviteToConference(STUser[] sTUserArray, String string) {
        if (this.m_confModel != null) {
            this.m_confModel.inviteToConference(sTUserArray, string);
        }
    }

    public MeetingInfo getConfInfo() {
        if (this.m_confModel != null) {
            return this.m_confModel.getConfInfo();
        }
        return null;
    }

    public Place getPlace() {
        if (this.m_confModel != null) {
            return this.m_confModel.getPlace();
        }
        return null;
    }

    public STSession getSession() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.getSession();
        }
        return this.m_confModel.getSession();
    }

    public STUser getPartner() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.getPartner();
        }
        return null;
    }

    public String getPartnerName() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.getPartnerName();
        }
        return null;
    }

    public STUser[] getPeople() {
        if (this.m_confModel != null) {
            return this.m_confModel.getPeople();
        }
        return null;
    }

    public boolean isEncrypted() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.isEncrypted();
        }
        return this.m_confModel.isEncrypted();
    }

    public boolean isAudioEnabled() {
        if (this.m_ImModel != null) {
            return this.m_ChatUIComp.isAudioEnabled();
        }
        return this.m_confModel.isAudioEnabled();
    }

    public boolean isAudioBridgeEnabled() {
        if (this.m_ImModel != null) {
            return this.m_ChatUIComp.isAudioBridgeEnabled();
        }
        return this.m_confModel.isAudioBridgeEnabled();
    }

    public boolean isVideoEnabled() {
        if (this.m_ImModel != null) {
            return this.m_ChatUIComp.isVideoEnabled();
        }
        return this.m_confModel.isVideoEnabled();
    }

    public boolean isMeetingEnabled() {
        if (StaticProps.m_bMacOSX) {
            return false;
        }
        if (this.m_ImModel != null) {
            return this.m_ChatUIComp.isMeetingEnabled();
        }
        return this.m_confModel.isMeetingEnabled();
    }

    public STUserStatus getPartnerStatus() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.getPartnerStatus();
        }
        return null;
    }

    public boolean isOmActive() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.isOmActive();
        }
        return false;
    }

    public boolean isViewEnabled() {
        if (this.m_ImModel != null) {
            return this.m_ImModel.isViewEnabled();
        }
        return this.m_confModel.isViewEnabled();
    }

    public void requestShowView(boolean bl) {
        if (this.m_ImModel != null) {
            this.m_ImModel.requestShowView(bl);
        } else {
            this.m_confModel.requestShowView(bl);
        }
    }

    public void requestToFront() {
        if (this.m_ImModel != null) {
            this.m_ImModel.requestToFront();
        } else {
            this.m_confModel.requestToFront();
        }
    }

    public void acceptInvitation() {
        if (this.m_confModel != null) {
            this.m_confModel.acceptInvitation();
        }
    }

    public void declineInvitation() {
        if (this.m_confModel != null) {
            this.m_confModel.declineInvitation();
        }
    }

    private void notifySwitchToConference() {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ChatModelListener chatModelListener = (ChatModelListener)enumeration.nextElement();
            chatModelListener.switchToConference();
        }
    }

    private void notifySwitchToMeeting(MeetingInfo meetingInfo) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ChatModelListener chatModelListener = (ChatModelListener)enumeration.nextElement();
            chatModelListener.switchToMeeting(meetingInfo);
        }
    }

    private STUser[] removeFromUserList(STUser sTUser, STUser[] sTUserArray) {
        int n;
        for (n = 0; n < sTUserArray.length && !sTUser.equals(sTUserArray[n]); ++n) {
        }
        if (n == sTUserArray.length) {
            return sTUserArray;
        }
        STUser[] sTUserArray2 = new STUser[sTUserArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < sTUserArray.length; ++i) {
            if (i == n) continue;
            sTUserArray2[n2++] = sTUserArray[i];
        }
        return sTUserArray2;
    }

    public boolean isWatsonServer(STSession sTSession) {
        CommunityService communityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        int n = communityService.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        return s > 30 || s == 30 && s2 >= 25;
    }

    class ImModelListenerImp
    extends ImModelAdapter {
        ImModelListenerImp() {
        }

        public void sendFailed(int n) {
            boolean bl;
            boolean bl2 = bl = n == -2147483642;
            if (!bl) {
                ChatModel.this.closeChat();
            }
        }
    }
}

