/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.buddylist;

import com.lotus.sametime.buddylist.BL;
import com.lotus.sametime.buddylist.BLEvent;
import com.lotus.sametime.buddylist.BLService;
import com.lotus.sametime.buddylist.BLServiceImpl;
import com.lotus.sametime.buddylist.BLServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BLComp
extends STComp
implements BLService {
    private BLServiceImpl m_impl = null;
    private Vector m_listeners = new Vector();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.buddylist");

    public BLComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.buddylist.BLComp", sTSession);
        this.m_impl = new BLServiceImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof BLEvent) {
            this.processBLEvent((BLEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    public void getBuddyList() {
        BLEvent bLEvent = new BLEvent(this, 10);
        this.sendEvent(bLEvent);
    }

    public BL stringToBuddyList(String string) {
        return this.m_impl.readBuddyList(string);
    }

    public String buddyListToString(BL bL) {
        return this.m_impl.convertBLToString(bL);
    }

    public void setBuddyList(BL bL) {
        BLEvent bLEvent = new BLEvent((Object)this, 11, bL);
        this.sendEvent(bLEvent);
    }

    public void deleteBuddyList() {
        BL bL = new BL();
        BLEvent bLEvent = new BLEvent((Object)this, 11, bL);
        this.sendEvent(bLEvent);
    }

    private void processBLEvent(BLEvent bLEvent) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            BLServiceListener bLServiceListener = (BLServiceListener)enumeration.nextElement();
            switch (bLEvent.getId()) {
                case 103: {
                    bLServiceListener.blRetrieveSucceeded(bLEvent);
                    break;
                }
                case 104: {
                    bLServiceListener.blRetrieveFailed(bLEvent);
                    break;
                }
                case 102: {
                    bLServiceListener.serviceAvailable(bLEvent);
                    break;
                }
                case 101: {
                    bLServiceListener.serviceUnavailable(bLEvent);
                    break;
                }
                case 105: {
                    bLServiceListener.blSetSucceeded(bLEvent);
                    break;
                }
                case 106: {
                    bLServiceListener.blSetFailed(bLEvent);
                    break;
                }
                case 107: {
                    bLServiceListener.blUpdated(bLEvent);
                    break;
                }
                case 108: {
                    bLServiceListener.blOverflowed(bLEvent);
                }
            }
        }
    }

    public synchronized void addBLServiceListener(BLServiceListener bLServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(bLServiceListener);
        this.m_listeners = vector;
    }

    public synchronized void removeBLServiceListener(BLServiceListener bLServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(bLServiceListener);
        this.m_listeners = vector;
    }

    public void setXmlBL() {
        BLServiceImpl.m_buddyListAttrKey = 8192;
    }

    public void setSametimeBL() {
        BLServiceImpl.m_buddyListAttrKey = 0;
    }

    public boolean isSametimeBL() {
        return BLServiceImpl.m_buddyListAttrKey == 0;
    }
}

