/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.av;

import com.lotus.sametime.awareness.AttributeAdapter;
import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.ChatController;
import com.lotus.sametime.awarenessui.av.ToolsDialog;
import com.lotus.sametime.chatui.AddToListListener;
import com.lotus.sametime.chatui.ChatFactory;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.ImageResources;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.tree.TreeNode;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class AVController
extends ChatController {
    protected MenuItem m_audio;
    protected MenuItem m_video;
    protected MenuItem m_share;
    protected MenuItem m_collaborate;
    protected MenuItem m_audioCall;
    protected MenuItem m_availableTools;
    private MenuItem m_addToList;
    private MenuItem m_editNickname;
    protected boolean m_audioEnabled = false;
    protected boolean m_audioCallEnabled = false;
    protected boolean m_shareEnabled = false;
    protected boolean m_videoEnabled = false;
    protected boolean m_meetingEnabled = false;
    protected boolean m_appShareEnabled = false;
    protected boolean m_wbEnabled = false;
    WatchList m_watchList;
    private ChatFactory m_factory;
    private CommunityService m_comm;

    public AVController(AwarenessModel awarenessModel) {
        super(awarenessModel);
        AwarenessService awarenessService = (AwarenessService)awarenessModel.getSession().getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        int[] nArray = new int[]{9002, 9003, 9001, 9024, 9025, 9024, 9025, 9061, 9029};
        awarenessService.addToAttrFilter(nArray);
        this.m_watchList = awarenessService.createWatchList();
        this.m_watchList.addAttrListener(new AttributeAdapter(){

            public void attrRemoved(AttributeEvent attributeEvent) {
                AVController.this.attrRemoved(attributeEvent);
            }

            public void attrChanged(AttributeEvent attributeEvent) {
                AVController.this.attrChanged(attributeEvent);
            }
        });
        this.m_comm = (CommunityService)awarenessModel.getSession().getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_comm.isLoggedIn()) {
            this.addServerToWatchList();
        }
        this.m_chat = (ChatUI)awarenessModel.getSession().getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_shareEnabled = this.m_chat.isAppShareEnabled() && this.m_chat.isWhiteBoardEnabled();
        this.m_factory = this.m_chat.getChatFactory();
    }

    private void addServerToWatchList() {
        Login login = this.m_comm.getLogin();
        STServer sTServer = login.getServer();
        String string = login.getMyUserInstance().getCommunityName();
        if (string.equals("")) {
            this.m_watchList.addItem(sTServer);
        } else {
            STServer sTServer2 = new STServer(new STId(sTServer.getId().getId(), string), sTServer.getName(), sTServer.getDesc());
            this.m_watchList.addItem(sTServer2);
        }
    }

    protected void createMenuItems() {
        super.createMenuItems();
        this.m_audio = new MenuItem(this.m_resource.getString("MENU_AUDIO"));
        this.m_audioCall = new MenuItem(this.m_resource.getString("MENU_AUDIO_CALL"));
        this.m_video = new MenuItem(this.m_resource.getString("MENU_VIDEO"));
        this.m_share = new MenuItem(this.m_resource.getString("MENU_SHARE"));
        this.m_collaborate = new MenuItem(this.m_resource.getString("MENU_COLLABORATE"));
        this.m_availableTools = new MenuItem(this.m_resource.getString("AVAILABLE_TOOLS"));
        this.m_addToList = new MenuItem(this.m_resource.getString("MENU_ADD_TO_LIST"));
        this.m_editNickname = new MenuItem(this.m_resource.getString("MENU_EDIT"));
    }

    protected void enablePopupItems(Vector vector) {
        AddToListListener addToListListener;
        boolean bl = false;
        boolean bl2 = false;
        this.m_popup.removeAll();
        this.m_popup.add(this.m_message);
        if (this.m_audioCallEnabled) {
            this.m_popup.add(this.m_audioCall);
        }
        if (this.m_phoneServiceId != null) {
            this.m_popup.add(this.m_startPhoneCall);
            this.m_startPhoneCall.setEnabled(vector.size() > 0);
        }
        if (this.m_announcementEnabled) {
            this.m_popup.add(this.m_announcement);
        }
        if (this.m_audioEnabled && this.m_meetingEnabled) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_audio);
        }
        if (this.m_videoEnabled && this.m_meetingEnabled) {
            this.m_popup.add(this.m_video);
        }
        if ((this.m_chat.isAppShareEnabled() || this.m_chat.isWhiteBoardEnabled()) && this.m_meetingEnabled) {
            this.m_popup.add(this.m_share);
        }
        if (this.m_meetingEnabled && (this.m_videoEnabled || this.m_audioEnabled)) {
            this.m_popup.add(this.m_collaborate);
        }
        if (this.m_fileTransferEnabled) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_fileTransfer);
        }
        if (this.m_meetingEnabled && (this.m_videoEnabled || this.m_audioEnabled)) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_availableTools);
        }
        if ((addToListListener = this.m_factory.getAddToListListener()) != null) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_editNickname);
            this.m_popup.add(this.m_addToList);
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)object.nextElement();
            if (!awarenessNode.isOnline()) continue;
            bl = true;
            break;
        }
        this.m_message.setEnabled(bl && this.m_messageEnabled);
        this.m_announcement.setEnabled(bl && this.m_messageEnabled);
        this.m_audio.setEnabled(bl && this.m_messageEnabled);
        this.m_video.setEnabled(bl && this.m_messageEnabled);
        this.m_share.setEnabled(bl && this.m_messageEnabled);
        this.m_collaborate.setEnabled(bl && this.m_messageEnabled);
        this.m_availableTools.setEnabled(bl && this.m_messageEnabled);
        this.m_audioCall.setEnabled(this.m_audioCallEnabled);
        this.m_remove.setEnabled(this.m_deleteEnabled);
        if (vector.size() == 1 && ((AwarenessNode)(object = (AwarenessNode)vector.elementAt(0))).isOnline() && !((STUser)((TreeNode)object).getKey()).isExternalUser()) {
            bl2 = true;
        }
        if (StaticProps.m_bUnixOS) {
            this.m_audio.setEnabled(false);
            this.m_video.setEnabled(false);
        }
        this.m_fileTransfer.setEnabled(bl2);
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.m_resource.getString("MENU_AUDIO")) {
            this.createMeeting(MeetingTypes.ST_AUDIO_MEETING);
        } else if (string == this.m_resource.getString("MENU_AUDIO_CALL")) {
            this.createMeeting(MeetingTypes.ST_AUDIO_CALL);
        } else if (string == this.m_resource.getString("MENU_VIDEO")) {
            this.createMeeting(MeetingTypes.ST_VIDEO_MEETING);
        } else if (string == this.m_resource.getString("MENU_SHARE")) {
            this.createMeeting(MeetingTypes.ST_SHARE_MEETING);
        } else if (string == this.m_resource.getString("MENU_COLLABORATE")) {
            this.createMeeting(MeetingTypes.ST_COLLABORATION_MEETING);
        } else if (string == this.m_resource.getString("AVAILABLE_TOOLS")) {
            this.displayAvailableTools();
        } else if (string == this.m_resource.getString("MENU_ADD_TO_LIST")) {
            STUser[] sTUserArray = this.m_model.getUsersFromNodes(this.m_selectedNodes);
            this.handleAddToList(sTUserArray);
        } else if (string == this.m_resource.getString("MENU_EDIT")) {
            STUser[] sTUserArray = this.m_model.getUsersFromNodes(this.m_selectedNodes);
            this.handleEditNickname(sTUserArray);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void createMeeting(MeetingTypes meetingTypes) {
        String string = this.m_commService.getLogin().getMyUserInstance().getName();
        String string2 = this.m_resource.getString("PLEASE_JOIN_THIS_MEETING");
        String string3 = this.m_resource.formatString("'S_MEETING", string);
        STBoolean sTBoolean = new STBoolean(false);
        STUser[] sTUserArray = this.m_model.getUsersFromNodes(this.m_selectedNodes, true, sTBoolean);
        if (meetingTypes == MeetingTypes.ST_AUDIO_CALL) {
            this.m_chat.createMeeting(meetingTypes, string3, null, false, sTUserArray);
        } else if (sTUserArray.length > 0) {
            this.m_chat.createMeeting(meetingTypes, string3, string2, true, sTUserArray);
        }
        if (sTBoolean.getValue()) {
            String string4 = "NON_ST_USERS_IN_AUDIO_MEETING";
            if (meetingTypes.equals(MeetingTypes.ST_AUDIOBRIDGE_MEETING)) {
                string4 = "NON_ST_USERS_IN_AUDIOBRIDGE_MEETING";
            } else if (meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING)) {
                string4 = "NON_ST_USERS_IN_VIDEO_MEETING";
            } else if (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING)) {
                string4 = "NON_ST_USERS_IN_COLLABORATION_MEETING";
            } else if (meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING)) {
                string4 = "NON_ST_USERS_IN_APPSHARE_MEETING";
            }
            Image image = ImageResources.getInstance().getImage("images/alert.gif");
            UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray(string4), this.m_resource.formatStringArray("BTN_LBL_OK"));
            ubqDialog.setImage(image);
            ubqDialog.setVisible(true);
        }
    }

    protected void displayAvailableTools() {
        STBoolean sTBoolean = new STBoolean(false);
        STUser[] sTUserArray = this.m_model.getUsersFromNodes(this.m_selectedNodes, true, sTBoolean);
        if (sTBoolean.getValue()) {
            // empty if block
        }
        ToolsDialog toolsDialog = new ToolsDialog(this.m_model.getSession(), sTUserArray);
        toolsDialog.setVisible(true);
    }

    protected void loggedIn(LoginEvent loginEvent) {
        this.addServerToWatchList();
        super.loggedIn(loginEvent);
    }

    protected void loggedOut(LoginEvent loginEvent) {
        this.m_audioEnabled = false;
        this.m_videoEnabled = false;
        this.m_meetingEnabled = false;
        this.m_watchList.reset();
        super.loggedOut(loginEvent);
    }

    protected void attrChanged(AttributeEvent attributeEvent) {
        super.attrChanged(attributeEvent);
        STExtendedAttribute[] sTExtendedAttributeArray = attributeEvent.getAttributeList();
        for (int i = 0; i < sTExtendedAttributeArray.length; ++i) {
            if (sTExtendedAttributeArray[i].getKey() == 9002) {
                this.m_audioEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9003) {
                this.m_videoEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9001) {
                this.m_meetingEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9024) {
                this.m_appShareEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9025) {
                this.m_wbEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() != 9061) continue;
            this.m_audioCallEnabled = true;
        }
    }

    protected void attrRemoved(AttributeEvent attributeEvent) {
        super.attrRemoved(attributeEvent);
        if (attributeEvent.getAttributeKey() == 9002) {
            this.m_audioEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9061) {
            this.m_audioCallEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9003) {
            this.m_videoEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9001) {
            this.m_meetingEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9024) {
            this.m_appShareEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9025) {
            this.m_wbEnabled = false;
        }
    }

    protected boolean isWatsonServer(STSession sTSession) {
        CommunityService communityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        int n = communityService.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        return s > 30 || s == 30 && s2 >= 25;
    }

    protected void handleAddToList(STUser[] sTUserArray) {
        AddToListListener addToListListener = this.m_factory.getAddToListListener();
        if (addToListListener != null) {
            addToListListener.addToList(sTUserArray);
        }
    }

    protected void handleEditNickname(STUser[] sTUserArray) {
        AddToListListener addToListListener = this.m_factory.getAddToListListener();
        if (addToListListener != null) {
            addToListListener.editNickname(sTUserArray[0]);
        }
    }
}

