/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui;

import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessModelListener;
import com.lotus.sametime.awarenessui.AwarenessViewController;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.awarenessui.AwarenessViewListener;
import com.lotus.sametime.gdk.tooltip.STToolTip;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.McListView;
import com.lotus.sametime.guiutils.tree.Sorter;
import com.lotus.sametime.guiutils.tree.TooltipProvider;
import com.lotus.sametime.guiutils.tree.TreeView;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AwarenessView
extends Panel
implements STToolTip {
    protected AwarenessModel m_model;
    protected AwarenessViewController m_controller;
    protected Vector m_stListeners = new Vector();
    protected STBundle m_res;
    protected TreeView m_treeView;
    protected McListView m_mcListView;

    protected AwarenessView(AwarenessModel awarenessModel, short s, boolean bl) {
        this.setLayout(new BorderLayout());
        this.m_treeView = new TreeView(awarenessModel, s, bl);
        this.add((Component)this.m_treeView, "Center");
        this.commonInit(awarenessModel);
    }

    protected AwarenessView() {
    }

    protected void commonInit(AwarenessModel awarenessModel) {
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)awarenessModel.getSession().getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_res = resourceLoaderService.getBundle("properties/awarenessui");
        this.m_model = awarenessModel;
        this.m_model.addTreeModelListener(this.m_treeView);
        this.m_model.addAwarenessModelListener(new AwarenessModelListener(){

            public void processAwarenessViewEvent(AwarenessViewEvent awarenessViewEvent) {
                AwarenessView.this.processAwarenessViewEvent(awarenessViewEvent);
            }
        });
        if (null != this.m_mcListView) {
            CellData cellData = new CellData(this.m_res.getString("NAME_COLUMN_TITLE"));
            this.setNameColData(cellData);
        }
    }

    protected void addAwarenessViewListener(AwarenessViewListener awarenessViewListener) {
        this.m_stListeners.addElement(awarenessViewListener);
    }

    protected void removeAwarenessViewListener(AwarenessViewListener awarenessViewListener) {
        this.m_stListeners.removeElement(awarenessViewListener);
    }

    public void setController(AwarenessViewController awarenessViewController) {
        this.m_treeView.removeViewListener(this.m_controller.getViewListener());
        this.m_treeView.removeKeyListener(this.m_controller.getKeyListener());
        this.m_controller = awarenessViewController;
        this.m_treeView.addViewListener(awarenessViewController.getViewListener());
        this.m_treeView.addKeyListener(awarenessViewController.getKeyListener());
    }

    public AwarenessViewController getController() {
        return this.m_controller;
    }

    public void enableDelete(boolean bl) {
        this.m_controller.enableDelete(bl);
    }

    public boolean isShowOnlineOnly() {
        return this.m_model.isShowOnlineOnly();
    }

    public void showOnlineOnly(boolean bl) {
        this.m_model.showOnlineOnly(bl);
    }

    public void setSortMode(boolean bl) {
        this.m_model.setSortMode(bl);
    }

    public void reset() {
        this.m_model.reset();
    }

    public void dispose() {
        this.m_model.dispose();
    }

    protected void processAwarenessViewEvent(AwarenessViewEvent awarenessViewEvent) {
        Enumeration enumeration = this.m_stListeners.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessViewListener awarenessViewListener = (AwarenessViewListener)enumeration.nextElement();
            switch (awarenessViewEvent.getId()) {
                case 9: {
                    awarenessViewListener.serviceAvailable(awarenessViewEvent);
                    break;
                }
                case 10: {
                    awarenessViewListener.serviceUnavailable(awarenessViewEvent);
                    break;
                }
                case 2: {
                    awarenessViewListener.addUserFailed(awarenessViewEvent);
                    break;
                }
                case 7: {
                    awarenessViewListener.statusChanged(awarenessViewEvent);
                    break;
                }
                case 8: {
                    awarenessViewListener.selectionChanged(awarenessViewEvent);
                    break;
                }
                case 1: {
                    awarenessViewListener.usersAdded(awarenessViewEvent);
                    break;
                }
                case 12: {
                    awarenessViewListener.usersRemoved(awarenessViewEvent);
                }
            }
        }
        if (awarenessViewEvent.getId() == 9) {
            this.m_controller.serviceUp();
        }
        if (awarenessViewEvent.getId() == 9) {
            this.m_controller.serviceDown();
        }
    }

    public AwarenessModel getModel() {
        return (AwarenessModel)this.m_treeView.getModel();
    }

    public void addColumn(ColumnAttributes columnAttributes) {
        int n = this.getModel().addColumn(columnAttributes);
        this.m_mcListView.addColumn(n, columnAttributes);
    }

    protected void setTooltipForNameColumn(String string) {
        if (null != this.m_mcListView) {
            this.m_mcListView.getTitleView().setTooltipForNameColumn(string);
        }
    }

    protected void setSorterForNameColumn(Sorter sorter) {
        if (null != this.m_mcListView) {
            this.m_mcListView.getTitleView().setSorterForNameColumn(sorter);
        }
        this.m_model.setSorter(sorter);
    }

    public void setTooltipProvider(TooltipProvider tooltipProvider) {
        this.m_treeView.setTooltipProvider(tooltipProvider);
    }

    protected void setNameColData(CellData cellData) {
        if (null != this.m_mcListView) {
            this.m_mcListView.getTitleView().setNameColData(cellData);
        }
    }

    public Vector getToolTipComponents() {
        Vector<TreeView> vector;
        if (null != this.m_mcListView) {
            vector = this.m_mcListView.getToolTipComponents();
        } else {
            vector = new Vector<TreeView>();
            vector.addElement(this.m_treeView);
        }
        return vector;
    }

    public void setHoverBased(boolean bl) {
    }

    public boolean isHoverBased() {
        return true;
    }

    public void setToolTipText(Component component, String string) {
    }

    public String getToolTipText(Component component, Point point) {
        if (this.getController().isPopupShowing()) {
            return null;
        }
        if (null != this.m_mcListView) {
            return this.m_mcListView.getToolTipText(component, point);
        }
        return this.m_treeView.getToolTipText(component, point);
    }

    protected void setResortAttrs(int[] nArray) {
        this.m_model.setResortAttribs(nArray);
    }

    public void reSort() {
        this.m_model.reSort();
    }

    public void setMinNameWidth(int n) {
        this.m_treeView.setMinNameWidth(n);
    }

    public void enableMultiSelection(boolean bl) {
        this.m_treeView.enableMultiSelection(bl);
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

