/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui;

import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.SystemColor;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwarenessNode
extends ModelNode {
    private static final Color ACTIVE_BG_COLOR = SystemColor.window;
    private static final Color ACTIVE_FG_COLOR = new Color(0, 128, 0);
    private static final Color ACTIVE_SELECTED_FG = ACTIVE_BG_COLOR;
    private static final Color ACTIVE_SELECTED_BG = ACTIVE_FG_COLOR;
    private static Font c_activeFont;
    private static Font c_font;
    private STUserStatus m_status;
    private String m_description;
    private String m_name;
    private Hashtable m_attributes = new Hashtable();
    protected STBundle m_res;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awarenessui");

    public AwarenessNode(Object object, String string, String string2, Image image, STBundle sTBundle) {
        super(object, string, image);
        this.m_name = string2;
        this.m_res = sTBundle;
        this.updateFonts();
    }

    public AwarenessNode(Object object, String string, Image image, STBundle sTBundle) {
        super(object, string, image);
        this.m_name = null;
        this.m_res = sTBundle;
        this.updateFonts();
    }

    public AwarenessNode(Object object, String string, String string2, Image image, Vector vector, Vector vector2, STBundle sTBundle) {
        super(object, string, image, vector, vector2);
        this.m_name = string2;
        this.m_res = sTBundle;
        this.updateFonts();
    }

    private void updateFonts() {
        if (null == c_font) {
            c_font = this.m_res.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE");
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "updateFonts", "Awareness Node Font Name: " + c_font.getName());
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "updateFonts", "Awareness Node Font Size: " + c_font.getSize());
            }
            c_activeFont = new Font(c_font.getName(), 1, c_font.getSize());
        }
    }

    public void setStatus(STUserStatus sTUserStatus) {
        this.m_status = sTUserStatus;
        this.m_description = sTUserStatus.getStatusDescription();
    }

    protected short getStatus() {
        return this.m_status.getStatusType();
    }

    public String getDescription() {
        String string = null;
        if (null == this.m_description || this.m_description.trim().length() == 0) {
            if (this.m_status.isStatus((short)512)) {
                string = this.m_res.formatString("IS_MOBILE", this.m_name);
            } else if (this.m_status.isStatus((short)32)) {
                string = this.m_res.formatString("IS_NOW_ACTIVE", this.m_name);
            } else if (this.m_status.isStatus((short)96)) {
                string = this.m_res.formatString("IS_NOW_AWAY", this.m_name);
            } else if (this.m_status.isStatus((short)128)) {
                string = this.m_res.formatString("ASKED_NOT_TO_BE_DISTURBED", this.m_name);
            } else if (this.m_status.isStatus((short)64)) {
                string = this.m_res.formatString("IS_NOT_USING", this.m_name);
            } else if (this.m_status.isStatus((short)0)) {
                string = this.m_res.formatString("IS_NOW_OFFLINE", this.m_name);
            } else if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getDescription", "getDescription() : Unknown user status - returning description null");
            }
        } else {
            String string2 = this.m_name != null ? this.m_name : this.m_value;
            string = string2 + ": " + this.m_description;
        }
        return string;
    }

    protected Color getBackground() {
        if (this.isOnline()) {
            if (this.isSelected()) {
                return ACTIVE_SELECTED_BG;
            }
            return ACTIVE_BG_COLOR;
        }
        return super.getBackground();
    }

    protected Color getForeground() {
        if (this.isOnline()) {
            if (this.isSelected()) {
                return ACTIVE_SELECTED_FG;
            }
            return ACTIVE_FG_COLOR;
        }
        return super.getForeground();
    }

    protected Font getFont() {
        if (this.isOnline()) {
            return c_activeFont;
        }
        return c_font;
    }

    public boolean isOnline() {
        return !this.m_status.isStatus((short)0);
    }

    public String getName() {
        return this.m_name;
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }
}

