/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awareness;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AwarenessImpl;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.AwarenessServiceEvent;
import com.lotus.sametime.awareness.AwarenessServiceListener;
import com.lotus.sametime.awareness.MyAttributeListener;
import com.lotus.sametime.awareness.StatusEvent;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwarenessComp
extends STComp
implements AwarenessService {
    private Vector m_serviceListeners = new Vector();
    private Vector m_GAListeners = new Vector();
    private AwarenessImpl m_impl = null;
    private Hashtable m_watchLists = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awareness");

    public AwarenessComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.awareness.AwarenessComp", sTSession);
        this.m_impl = new AwarenessImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public synchronized void addAwarenessServiceListener(AwarenessServiceListener awarenessServiceListener) {
        Vector vector = (Vector)this.m_serviceListeners.clone();
        vector.addElement(awarenessServiceListener);
        this.m_serviceListeners = vector;
    }

    public synchronized void removeAwarenessServiceListener(AwarenessServiceListener awarenessServiceListener) {
        Vector vector = (Vector)this.m_serviceListeners.clone();
        vector.removeElement(awarenessServiceListener);
        this.m_serviceListeners = vector;
    }

    public synchronized void addMyAttributeListener(MyAttributeListener myAttributeListener) {
        Vector vector = (Vector)this.m_GAListeners.clone();
        vector.addElement(myAttributeListener);
        this.m_GAListeners = vector;
    }

    public synchronized void removeMyAttributeListener(MyAttributeListener myAttributeListener) {
        Vector vector = (Vector)this.m_GAListeners.clone();
        vector.removeElement(myAttributeListener);
        this.m_GAListeners = vector;
    }

    public boolean isServiceAvailable() {
        return this.m_impl.isServiceAvailable();
    }

    public WatchList createWatchList() {
        Integer n = STCompPart.getUniqueId();
        WatchList watchList = new WatchList(this, n);
        this.m_watchLists.put(n, watchList);
        StatusEvent statusEvent = new StatusEvent(this, 1, n);
        this.sendEvent(statusEvent);
        return watchList;
    }

    protected void destroyList(Integer n) {
        StatusEvent statusEvent = new StatusEvent(this, 2, n);
        this.sendEvent(statusEvent);
        this.m_watchLists.remove(n);
    }

    protected void watchObjects(Integer n, STObject[] sTObjectArray) {
        StatusEvent statusEvent = new StatusEvent((Object)this, 5, n, sTObjectArray);
        this.sendEvent(statusEvent);
    }

    protected void stopWatch(Integer n, STObject[] sTObjectArray) {
        StatusEvent statusEvent = new StatusEvent((Object)this, 6, n, sTObjectArray);
        this.sendEvent(statusEvent);
    }

    protected void resetList(Integer n) {
        StatusEvent statusEvent = new StatusEvent(this, 3, n);
        this.sendEvent(statusEvent);
    }

    public void changeMyAttr(STExtendedAttribute sTExtendedAttribute) {
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 201, sTExtendedAttribute);
        this.sendEvent(attributeEvent);
    }

    public void removeMyAttr(int n) {
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 202, n);
        this.sendEvent(attributeEvent);
    }

    public void setAttrFilter(int[] nArray) {
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 203, nArray);
        this.sendEvent(attributeEvent);
    }

    public void addToAttrFilter(int[] nArray) {
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 205, nArray);
        this.sendEvent(attributeEvent);
    }

    public void removeFromAttrFilter(int[] nArray) {
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 206, nArray);
        this.sendEvent(attributeEvent);
    }

    protected void getAttributeContent(Integer n, STObject sTObject, int n2) {
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 204, sTObject, n2, (int)n);
        this.sendEvent(attributeEvent);
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof StatusEvent) {
            this.processStatusEvent((StatusEvent)sTEvent);
        } else if (sTEvent instanceof AttributeEvent) {
            this.processAttributeEvent((AttributeEvent)sTEvent);
        } else if (sTEvent instanceof AwarenessServiceEvent) {
            this.processServiceEvent((AwarenessServiceEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processStatusEvent(StatusEvent statusEvent) {
        WatchList watchList = (WatchList)this.m_watchLists.get(statusEvent.getListId());
        if (null != watchList) {
            watchList.dispatchStatusEvent(statusEvent);
        }
    }

    protected void processServiceEvent(AwarenessServiceEvent awarenessServiceEvent) {
        Vector vector = this.m_serviceListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessServiceListener awarenessServiceListener = (AwarenessServiceListener)enumeration.nextElement();
            switch (awarenessServiceEvent.getId()) {
                case -2147483644: {
                    awarenessServiceListener.serviceAvailable(awarenessServiceEvent);
                    break;
                }
                case -2147483643: {
                    awarenessServiceListener.serviceUnavailable(awarenessServiceEvent);
                }
            }
        }
    }

    protected void processAttributeEvent(AttributeEvent attributeEvent) {
        switch (attributeEvent.getId()) {
            case 603: 
            case 605: 
            case 606: 
            case 607: {
                this.dispatchMyAttrEvent(attributeEvent);
                break;
            }
            case 601: 
            case 602: 
            case 608: 
            case 609: {
                WatchList watchList = (WatchList)this.m_watchLists.get(attributeEvent.getListId());
                if (null == watchList) break;
                watchList.dispatchAttrEvent(attributeEvent);
                break;
            }
        }
    }

    private void dispatchMyAttrEvent(AttributeEvent attributeEvent) {
        Vector vector = this.m_GAListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MyAttributeListener myAttributeListener = (MyAttributeListener)enumeration.nextElement();
            switch (attributeEvent.getId()) {
                case 605: {
                    myAttributeListener.myAttrChanged(attributeEvent);
                    break;
                }
                case 603: {
                    myAttributeListener.changeMyAttrFailed(attributeEvent);
                    break;
                }
                case 606: {
                    myAttributeListener.myAttrRemoved(attributeEvent);
                    break;
                }
                case 607: {
                    myAttributeListener.removeMyAttrFailed(attributeEvent);
                }
            }
        }
    }

    public STUserStatus findUserStatus(STUser sTUser) {
        return this.m_impl.findUserStatus(sTUser);
    }
}

