/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.announcementui;

import com.lotus.sametime.announcement.AnnouncementEvent;
import com.lotus.sametime.announcement.AnnouncementListener;
import com.lotus.sametime.announcement.AnnouncementService;
import com.lotus.sametime.announcementui.AnnouncementDialog;
import com.lotus.sametime.announcementui.AnnouncementUI;
import com.lotus.sametime.announcementui.SendAnnouncementDialog;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUserStatus;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnouncementUIComp
extends STComp
implements AnnouncementUI {
    private STSession m_session;
    private AnnouncementService m_announcementSvc;
    private CommunityService m_communitySvc;
    private AnnouncementEventHandler m_announcementEventHandler;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.announcementui");

    public AnnouncementUIComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.announcementui.AnnouncementUIComp", sTSession);
        this.m_session = sTSession;
        this.m_session.registerComponent(this.getName(), this);
        this.m_announcementEventHandler = new AnnouncementEventHandler();
        this.m_announcementSvc = (AnnouncementService)this.m_session.getCompApi("com.lotus.sametime.announcement.AnnouncementComp");
        if (this.m_announcementSvc != null) {
            this.m_announcementSvc.addAnnouncementListener(this.m_announcementEventHandler);
        }
        this.m_communitySvc = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (this.m_announcementSvc == null && sTCompApi instanceof AnnouncementService) {
            this.m_announcementSvc = (AnnouncementService)sTCompApi;
        }
    }

    public void sendAnnouncement(STObject[] sTObjectArray) {
        SendAnnouncementDialog sendAnnouncementDialog = new SendAnnouncementDialog(this.getMainFrame(), this.m_session, sTObjectArray);
    }

    private Frame getMainFrame() {
        Frame frame = (Frame)this.m_session.getSessionProperty("mainFrame");
        return frame == null ? new Frame() : frame;
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
        this.m_announcementSvc.removeAnnouncementListener(this.m_announcementEventHandler);
    }

    private class AnnouncementEventHandler
    implements AnnouncementListener {
        private AnnouncementEventHandler() {
        }

        public void announcementReceived(AnnouncementEvent announcementEvent) {
            STUserStatus sTUserStatus = AnnouncementUIComp.this.m_communitySvc.getLogin().getMyStatus();
            if (!sTUserStatus.isStatus((short)128)) {
                AnnouncementDialog announcementDialog = new AnnouncementDialog(AnnouncementUIComp.this.m_session, announcementEvent);
            }
        }
    }
}

