/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.aws.lambda;

import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.util.List;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.EnvironmentError;
import software.amazon.awssdk.services.lambda.model.EnvironmentResponse;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.Layer;
import software.amazon.awssdk.services.lambda.model.TracingConfigResponse;
import software.amazon.awssdk.services.lambda.model.VpcConfigResponse;

public class LambdaResponseUtil {
    public static Array getListResults(List<FunctionConfiguration> list) {
        Array result = new Array();
        for (FunctionConfiguration config : list) {
            if (config == null) continue;
            Struct struct = new Struct();
            struct.put((Object)"functionName", (Object)config.functionName());
            struct.put((Object)"functionArn", (Object)config.functionArn());
            struct.put((Object)"runtime", (Object)config.runtime());
            struct.put((Object)"role", (Object)config.role());
            struct.put((Object)"handler", (Object)config.handler());
            struct.put((Object)"codeSize", (Object)config.codeSize());
            struct.put((Object)"description", (Object)config.description());
            struct.put((Object)"timeout", (Object)config.timeout());
            struct.put((Object)"memorySize", (Object)config.memorySize());
            struct.put((Object)"lastModified", (Object)config.lastModified());
            struct.put((Object)"codeSha256", (Object)config.codeSha256());
            struct.put((Object)"version", (Object)config.version());
            struct.put((Object)"kmsKeyArn", (Object)config.kmsKeyArn());
            struct.put((Object)"masterArn", (Object)config.masterArn());
            struct.put((Object)"revisionId", (Object)config.revisionId());
            if (config.vpcConfig() != null) {
                VpcConfigResponse vpcConfig = config.vpcConfig();
                Struct vpcStruct = new Struct();
                vpcStruct.put((Object)"vpcId", (Object)vpcConfig.vpcId());
                if (vpcConfig.securityGroupIds() != null) {
                    Array secGroup = new Array();
                    for (String secGroupId : vpcConfig.securityGroupIds()) {
                        secGroup.addElement((Object)secGroupId);
                    }
                    vpcStruct.put((Object)"securityGroupIds", (Object)secGroup);
                }
                if (vpcConfig.subnetIds() != null) {
                    Array subnets = new Array();
                    for (String secGroupId : vpcConfig.subnetIds()) {
                        subnets.addElement((Object)secGroupId);
                    }
                    vpcStruct.put((Object)"subnetIds", (Object)subnets);
                }
            }
            if (config.deadLetterConfig() != null) {
                DeadLetterConfig deadLetterConfig = config.deadLetterConfig();
                Struct dlcStruct = new Struct();
                dlcStruct.put((Object)"targetArn", (Object)deadLetterConfig.targetArn());
                struct.put((Object)"deadLetterConfig", (Object)dlcStruct);
            }
            if (config.tracingConfig() != null) {
                TracingConfigResponse tracingConfig = config.tracingConfig();
                Struct tracingConfigStruct = new Struct();
                tracingConfigStruct.put((Object)"mode", (Object)tracingConfig.mode());
                struct.put((Object)"tracingConfig", (Object)tracingConfigStruct);
            }
            if (config.layers() != null) {
                List layers = config.layers();
                Array layerArray = new Array();
                for (Layer layer : layers) {
                    Struct layerStruct = new Struct();
                    layerStruct.put((Object)"arn", (Object)layer.arn());
                    layerStruct.put((Object)"codeSize", (Object)layer.codeSize());
                    layerArray.addElement((Object)layerStruct);
                }
                struct.put((Object)"layers", (Object)layerArray);
            }
            if (config.environment() != null) {
                EnvironmentResponse environmentResponse = config.environment();
                Struct environment = new Struct();
                Struct environmentVariables = new Struct();
                if (environmentResponse != null) {
                    if (environmentResponse.variables() != null) {
                        environmentVariables.putAll(environmentResponse.variables());
                        environment.put((Object)"variables", (Object)environmentVariables);
                    }
                    EnvironmentError error = environmentResponse.error();
                    Struct errorStruct = new Struct();
                    if (error != null) {
                        errorStruct.put((Object)"code", (Object)error.errorCode());
                        errorStruct.put((Object)"message", (Object)error.message());
                        environment.put((Object)"error", (Object)errorStruct);
                    }
                }
                struct.put((Object)"environment", (Object)environment);
            }
            result.add((Object)struct);
        }
        return result;
    }
}

