/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.image;

import coldfusion.image.CaptchaMaker;
import coldfusion.image.Image;
import coldfusion.image.core.ImageExceptions;
import coldfusion.runtime.CFVariableLexer;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.util.CFFileServlet;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.wddx.Base64Encoder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;

public class ImageTag
extends GenericTag {
    private static final long serialVersionUID = 1L;
    private Object source = null;
    private String destination = null;
    private String shortDestination = null;
    private String action = "read";
    private String name = null;
    private String height = null;
    private String width = null;
    private boolean overwrite = false;
    private String format = null;
    private float angle = 0.0f;
    private String structname = null;
    private int thickness = 1;
    private String color = "#000000";
    private boolean isBase64 = false;
    private int fontSize = 24;
    private String fonts = null;
    private Image img = null;
    private float quality = 0.75f;
    private String text = null;
    private int difficulty = 0;
    String interpolation = Image.HIGHESTQUALITY;
    private Map extraAttributes = null;
    private static final String TEMP_CAPTCHA_FOLDER = "CFFileServlet/_cf_captcha";
    public static final String TEMP_IMAGE_FOLDER = "CFFileServlet/_cf_image";
    private static boolean captchCleanupInitialized = false;
    private static boolean imgCleanupInitialized = false;
    private static final Random rand = new Random();
    private boolean progressive = false;

    public void setInterpolation(String interpolation) {
        this.interpolation = interpolation;
    }

    public void setDifficulty(String difficulty) {
        if (difficulty.equalsIgnoreCase("low")) {
            this.difficulty = 0;
        } else if (difficulty.equalsIgnoreCase("medium")) {
            this.difficulty = 1;
        } else if (difficulty.equalsIgnoreCase("high")) {
            this.difficulty = 2;
        } else {
            throw new ImageExceptions.UnsupportedCaptchaDifficultyException();
        }
    }

    public void setAngle(double angle) {
        this.angle = (float)angle;
    }

    public void setQuality(double quality) {
        this.quality = (float)quality;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setStructname(String structname) {
        this.structname = structname;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setProgressive(boolean progressive) {
        this.progressive = progressive;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFontSize(int fontSize) {
        if (fontSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.fontSize = fontSize;
    }

    public void setFonts(String fonts) {
        this.fonts = fonts;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setIsBase64(boolean isBase64) {
        this.isBase64 = isBase64;
    }

    public void setDestination(String destination) {
        if (!(this.action.trim().equalsIgnoreCase("captcha") || destination != null && destination.trim().length() != 0)) {
            throw new ImageExceptions.InvalidDestinationException();
        }
        this.shortDestination = destination;
        this.destination = Utils.getFileFullPath((String)destination, (PageContext)this.pageContext, (boolean)true);
    }

    public void setSource(Object source) {
        if (source == null) {
            throw new ImageExceptions.InvalidSourceException();
        }
        this.source = source;
    }

    public void setAction(String action) {
        this.action = action != null ? action : "read";
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new ImageExceptions.InvalidNameException();
        }
        this.name = name;
    }

    public void setThickness(int thickness) {
        if (thickness < 0) {
            throw new ImageExceptions.NegativeThicknessException();
        }
        this.thickness = thickness;
    }

    public void setAttributecollection(Map map) {
        if (map != null) {
            this.extraAttributes = new Hashtable();
            for (String key : map.keySet()) {
                this.extraAttributes.put(key.toLowerCase(), map.get(key).toString());
            }
        }
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        String temp = this.action.trim();
        if (temp.equalsIgnoreCase("captcha")) {
            this.handleCaptchaRequest();
            this.onTagEnd();
            return 0;
        }
        if (this.source != null) {
            if (this.source instanceof Image) {
                this.img = new Image((Image)this.source);
            } else if (this.source.getClass().isArray() || this.source instanceof byte[]) {
                this.img = new Image((byte[])this.source);
            } else if (this.source instanceof String) {
                if (this.isBase64) {
                    Image tempImg = new Image();
                    tempImg.readBase64((String)this.source);
                    this.img = tempImg;
                } else {
                    this.img = new Image((String)this.source, this.pageContext);
                }
            } else {
                throw new ImageExceptions.InvalidInputException();
            }
            BufferedImage cmykImg = this.img.convertCMYKToRGB();
            if (null != cmykImg) {
                this.img.setCurrentImage(cmykImg);
            }
        } else {
            throw new ImageExceptions.InvalidInputException();
        }
        if (this.img == null) {
            throw new ImageExceptions.UnableToCreateCFImageException();
        }
        if (!(temp.equalsIgnoreCase("read") || temp.equalsIgnoreCase("write") || temp.equalsIgnoreCase("info") || temp.equalsIgnoreCase("writetobrowser") || this.img.getCurrentImage() == null)) {
            this.img.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            this.img.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.img.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.img.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            this.img.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.img.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            this.img.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            this.img.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        if (temp.equalsIgnoreCase("writetobrowser")) {
            if (this.format == null || this.format.trim().length() == 0) {
                this.format = "PNG";
            }
            this.writeImageToBrowser(this.format);
        } else if (temp.equalsIgnoreCase("resize")) {
            this.img.resize(this.width, this.height, this.interpolation);
        } else if (temp.equalsIgnoreCase("border")) {
            this.img.addBorder(this.thickness, "CONSTANT", this.color);
        } else if (temp.equalsIgnoreCase("rotate")) {
            this.img.rotate(this.img.getWidth() / 2, this.img.getHeight() / 2, this.angle, "bicubic");
        } else if (temp.equalsIgnoreCase("info")) {
            if (!CFVariableLexer.isValidVariableName((String)this.structname)) {
                throw new IllegalArgumentException();
            }
            this.pageContext.setAttribute(this.structname, (Object)this.img.info());
        } else if (!(temp.equalsIgnoreCase("read") || temp.equalsIgnoreCase("write") || temp.equalsIgnoreCase("convert"))) {
            throw new ImageExceptions.UnsupportedImageActionException(this.action);
        }
        if (temp.equalsIgnoreCase("convert")) {
            this.img.convertCMYKToRGB();
        }
        if (!(this.action.equalsIgnoreCase("info") || this.action.equalsIgnoreCase("writetobrowser") || this.action.equalsIgnoreCase("read"))) {
            this.performWrite(this.action, this.destination, this.pageContext);
        }
        if (this.name != null) {
            if (!CFVariableLexer.isValidVariableName((String)this.name)) {
                throw new IllegalArgumentException();
            }
            this.pageContext.setAttribute(this.name, (Object)new Image(this.img));
        }
        this.onTagEnd();
        return 0;
    }

    private void handleCaptchaRequest() {
        int h;
        int w;
        if (null == this.width) {
            this.width = Integer.toString((int)Math.round(1.5 * (double)this.text.length() * (double)this.fontSize * 0.72 + 1.0));
        }
        if (null == this.height) {
            this.height = Integer.toString((int)Math.round((double)(2 * this.fontSize) * 0.72 + 1.0));
        }
        try {
            w = Integer.parseInt(this.width);
        }
        catch (NumberFormatException e) {
            throw new ImageExceptions.InvalidNumberException("width");
        }
        try {
            h = Integer.parseInt(this.height);
        }
        catch (NumberFormatException e) {
            throw new ImageExceptions.InvalidNumberException("height");
        }
        CaptchaMaker cm = new CaptchaMaker(w, h, this.text, this.fontSize, this.fonts);
        this.img = new Image(cm.createCaptcha(this.difficulty));
        boolean destinationGiven = false;
        boolean nameGiven = false;
        try {
            if (this.destination != null && this.destination.trim().length() > 0) {
                destinationGiven = true;
                this.performWrite(this.action, this.destination, this.pageContext);
            }
            if (this.name != null) {
                nameGiven = true;
                if (!CFVariableLexer.isValidVariableName((String)this.name)) {
                    throw new IllegalArgumentException();
                }
                this.pageContext.setAttribute(this.name, (Object)new Image(this.img));
            }
            if (!destinationGiven && !nameGiven) {
                StringBuffer sb = new StringBuffer("<img src=\"");
                File captchaFile = this.writeTempCaptchaFile();
                sb.append(this.getTempImgURI(captchaFile.getName(), TEMP_CAPTCHA_FOLDER));
                CFFileServlet.submitTaskForCleanup((File)captchaFile, (int)this.getTempImgExpiryTime());
                sb.append("\"");
                if (this.extraAttributes != null) {
                    for (String key : this.extraAttributes.keySet()) {
                        if ("src".equalsIgnoreCase(key)) continue;
                        String value = this.extraAttributes.get(key).toString();
                        sb.append(" " + key + "=\"" + value + "\"");
                    }
                }
                if (this.extraAttributes == null || !this.extraAttributes.containsKey("alt")) {
                    sb.append(" alt=\"\"");
                }
                sb.append(" height=\"" + h + "\" width=\"" + w + "\" />");
                this.out.println(sb.toString());
            }
        }
        catch (Exception e) {
            throw new ImageExceptions.ImageActionException(this.action, e.toString());
        }
    }

    private File writeTempCaptchaFile() throws Exception {
        if (System.getSecurityManager() == null) {
            return this._writeTempCaptchaFile();
        }
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ImageTag.this._writeTempCaptchaFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private File _writeTempCaptchaFile() throws Exception {
        File captchaFile = this.getCaptchaFile();
        this.writeTempImageFile(captchaFile);
        return captchaFile;
    }

    public void release() {
        this.source = null;
        this.destination = null;
        this.action = "read";
        this.name = null;
        this.height = null;
        this.width = null;
        this.overwrite = false;
        this.angle = 0.0f;
        this.structname = null;
        this.thickness = 1;
        this.img = null;
        this.color = "black";
        this.isBase64 = false;
        this.format = "PNG";
        this.fontSize = 24;
        this.fonts = null;
        this.text = null;
        this.shortDestination = null;
    }

    private void writeImageToBrowser(String format) {
        try {
            if (ServerlessUtil.isLambdaEnv()) {
                if (this.out == null) {
                    return;
                }
                File imageFile = VFSFileFactory.getFileObject((String)((String)this.source));
                String mimetype = MimeTypeUtils.guessMimeType((String)imageFile.getAbsolutePath());
                if (mimetype == null) {
                    throw new ImageExceptions.ImageActionException(this.action, "Could not determine the MIME type of the file: " + imageFile.getPath());
                }
                if (imageFile == null || !imageFile.exists()) {
                    throw new ImageExceptions.ImageActionException(this.action, "Unable to read the file: " + imageFile.getPath());
                }
                FileInputStream fileInputStreamReader = new FileInputStream(imageFile);
                byte[] imagebytes = new byte[(int)imageFile.length()];
                fileInputStreamReader.read(imagebytes);
                if (fileInputStreamReader != null) {
                    fileInputStreamReader.close();
                }
                String base64Image = Base64Encoder.encode((byte[])imagebytes);
                this.out.print("<img src=\"data:" + mimetype + ";base64," + base64Image + "\"");
                if (this.extraAttributes != null) {
                    for (String key : this.extraAttributes.keySet()) {
                        if ("src".equalsIgnoreCase(key)) continue;
                        String value = this.extraAttributes.get(key).toString();
                        this.out.print(" " + key + "=\"" + value + "\"");
                    }
                }
                if (this.height != null) {
                    this.out.print(" height=\"" + this.height + "\"");
                }
                if (this.width != null) {
                    this.out.print(" width=\"" + this.width + "\"");
                }
                if (this.extraAttributes == null || !this.extraAttributes.containsKey("alt")) {
                    this.out.print(" alt=\"\"");
                }
                this.out.println(" />");
            } else {
                File imageFile = this.getTempImageFile(format);
                this.writeTempImageFile(imageFile);
                if (this.out == null) {
                    return;
                }
                this.out.print("<img src=\"" + this.getTempImgURI(imageFile.getName(), TEMP_IMAGE_FOLDER) + "\"");
                if (this.extraAttributes != null) {
                    for (String key : this.extraAttributes.keySet()) {
                        if ("src".equalsIgnoreCase(key)) continue;
                        String value = this.extraAttributes.get(key).toString();
                        this.out.print(" " + key + "=\"" + value + "\"");
                    }
                }
                if (this.height != null) {
                    this.out.print(" height=\"" + this.height + "\"");
                }
                if (this.width != null) {
                    this.out.print(" width=\"" + this.width + "\"");
                }
                if (this.extraAttributes == null || !this.extraAttributes.containsKey("alt")) {
                    this.out.print(" alt=\"\"");
                }
                this.out.println(" />");
                CFFileServlet.submitTaskForCleanup((File)imageFile, (int)this.getTempImgExpiryTime());
            }
        }
        catch (Exception e) {
            throw new ImageExceptions.ImageActionException(this.action, e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performWrite(String action, String destinationFile, PageContext pageContext) throws ImageExceptions.FileOverwriteException {
        if (this.img == null) throw new ImageExceptions.ImageActionException(action, "Internal error: Missing image to write");
        if (destinationFile == null) return;
        if (destinationFile.trim().length() == 0) throw new IllegalArgumentException("The name of the destination file is invalid.");
        this.img.write(destinationFile, this.quality, this.overwrite, pageContext, this.progressive);
    }

    private File getTempImageFile(final String format) {
        if (System.getSecurityManager() == null) {
            return this._getTempImageFile(format);
        }
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ImageTag.this._getTempImageFile(format);
            }
        });
    }

    private File _getTempImageFile(String format) {
        String imgFileName;
        File imgFile;
        File tempDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), TEMP_IMAGE_FOLDER);
        if (!imgCleanupInitialized) {
            CFFileServlet.cleanupTempCache((File)tempDir, (int)this.getTempImgExpiryTime());
            tempDir.mkdirs();
            imgCleanupInitialized = true;
        }
        while ((imgFile = new File(tempDir, imgFileName = "_cfimg" + rand.nextLong() + "." + format)).exists()) {
        }
        return imgFile;
    }

    private File getCaptchaFile() {
        String captchaFileName;
        File captchaFile;
        File tempDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), TEMP_CAPTCHA_FOLDER);
        if (!captchCleanupInitialized) {
            CFFileServlet.cleanupTempCache((File)tempDir, (int)this.getTempImgExpiryTime());
            tempDir.mkdirs();
            captchCleanupInitialized = true;
        }
        while ((captchaFile = new File(tempDir, captchaFileName = "_captcha_img" + rand.nextLong() + ".png")).exists()) {
        }
        return captchaFile;
    }

    private String getTempImgURI(String imgFileName, String tempFolderName) {
        Object imgURI = "";
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        if (req.getContextPath() != null) {
            imgURI = req.getContextPath();
        }
        imgURI = (String)imgURI + "/" + tempFolderName + "/" + imgFileName;
        return imgURI;
    }

    private int getTempImgExpiryTime() {
        return ServiceFactory.getRuntimeService().getCFImageExpiryTime();
    }

    private void writeTempImageFile(final File captchaFile) throws Exception {
        if (System.getSecurityManager() == null) {
            this.performWrite(this.action, captchaFile.getAbsolutePath(), this.pageContext);
        } else {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ImageTag.this.performWrite(ImageTag.this.action, captchaFile.getAbsolutePath(), ImageTag.this.pageContext);
                    return null;
                }
            });
        }
    }
}

