/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.core.ImageExceptions;
import coldfusion.vfs.VFSFileFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageReader {
    private static final String ICC_APP2_ENCOUNTERED_WITHOUT_PRIOR_JFIF = "ICC APP2 encountered without prior JFIF";
    private static final String NOT_A_JPEG_FILE = "Not a JPEG file:";
    private static final String UNSUPPORTED_IMAGE_TYPE = "Unsupported Image Type";
    private static final String tempDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            Object path = System.getProperty("java.io.tmpdir");
            if (!((String)path).endsWith(File.separator)) {
                path = (String)path + File.separator;
            }
            return path;
        }
    });
    private static final FilePermission tempDirFullPermission = new FilePermission(tempDir + "*", "read,write,delete");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(Object source, String format) throws ImageExceptions.ImageReadingException {
        BufferedImage image;
        block14: {
            image = null;
            if (format == null || format != null && format.length() == 0) {
                throw new ImageExceptions.NoImageFormatException();
            }
            try {
                if (format.equals("jpg") || format.equals("jpeg")) {
                    image = ImageReader.readJPEGImage(source);
                    break block14;
                }
                InputStream istream = null;
                try {
                    istream = ImageReader.getInputStream(source);
                    image = ImageReader.readImageForUnknownFormat(istream);
                }
                catch (Exception e) {
                    try {
                        istream = ImageReader.closeAndOpenInputStream(source, istream);
                        image = ImageIO.read(istream);
                    }
                    catch (Exception e1) {
                        throw new ImageExceptions.ImageReadingException(e1.toString());
                    }
                    ImageReader.closeInputStream(istream);
                }
                finally {
                    ImageReader.closeInputStream(istream);
                }
            }
            catch (Exception e) {
                throw new ImageExceptions.ImageReadingException(e.toString());
            }
        }
        if (image == null) {
            throw new ImageExceptions.UnableToCreateImageException();
        }
        return image;
    }

    /*
     * Exception decompiling
     */
    public static BufferedImage readJPEGImage(Object source) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 16[CATCHBLOCK], 15[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream closeAndOpenInputStream(Object source, InputStream inputStream) throws IOException {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ImageReader.getInputStream(source);
    }

    private static InputStream getInputStream(Object source) throws IOException {
        if (source instanceof byte[]) {
            return new ByteArrayInputStream((byte[])source);
        }
        if (source instanceof File) {
            return VFSFileFactory.getInputStream((File)((File)source));
        }
        if (source instanceof URL) {
            return ((URL)source).openStream();
        }
        throw new ImageExceptions.InvalidImageSourceException();
    }

    private static BufferedImage readImageForUnknownFormat(InputStream istream) throws Exception {
        BufferedImage image = null;
        ImageInputStream iis = ImageReader.createImageInputStream(istream);
        Iterator<javax.imageio.ImageReader> imageReaders = ImageIO.getImageReaders(iis);
        javax.imageio.ImageReader reader = null;
        if (imageReaders.hasNext()) {
            reader = imageReaders.next();
        }
        if (reader == null) {
            throw new ImageExceptions.NoSuitableReaderFoundException();
        }
        reader.setInput(iis, true, true);
        image = reader.read(0);
        return image;
    }

    private static ImageInputStream createImageInputStream(final InputStream istream) throws IOException {
        if (System.getSecurityManager() == null) {
            return ImageIO.createImageInputStream(istream);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ImageInputStream>(){

                @Override
                public ImageInputStream run() throws IOException {
                    return ImageIO.createImageInputStream(istream);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }

    public static BufferedImage readImage(byte[] data) throws ImageExceptions.ImageReadingException {
        BufferedImage image;
        try {
            MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(new ByteArrayInputStream(data));
            image = ImageIO.read(iis);
        }
        catch (IOException e) {
            throw new ImageExceptions.ImageReadingException(e.getMessage());
        }
        if (image == null) {
            throw new ImageExceptions.UnableToCreateImageException();
        }
        return image;
    }

    private static void closeInputStream(InputStream istream) {
        try {
            if (istream != null) {
                istream.close();
                istream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readJPEGImage(ImageInputStream input) throws IOException {
        javax.imageio.ImageReader reader = ImageReader.getJpegImageReader();
        try {
            reader.setInput(input, true, true);
            BufferedImage bufferedImage = reader.read(0);
            return bufferedImage;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private static javax.imageio.ImageReader getJpegImageReader() {
        Iterator<javax.imageio.ImageReader> iter = ImageIO.getImageReadersByFormatName("jpeg");
        javax.imageio.ImageReader reader = null;
        while (iter.hasNext() && (reader = iter.next()).getClass().getName().equals("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader")) {
        }
        return reader;
    }

    public static String getReadableFormats() {
        Object[] readFormats = ImageIO.getReaderFormatNames();
        Arrays.sort(readFormats);
        Object temp = "";
        for (int i = 0; i < readFormats.length; ++i) {
            if (((String)temp).indexOf(((String)readFormats[i]).toUpperCase()) != -1) continue;
            temp = (String)temp + ((String)readFormats[i]).toUpperCase() + ",";
        }
        return ((String)temp).substring(0, ((String)temp).length() - 1);
    }

    public static String getReadableFormatsForOSX() {
        return "BMP,FPX,GIF,JPEG,PNG,PNM";
    }

    private static BufferedImage readImageUsingImageIO(final InputStream iStream) throws Throwable {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedImage>(){

                    @Override
                    public BufferedImage run() throws Exception {
                        return ImageIO.read(iStream);
                    }
                }, null, tempDirFullPermission);
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
        return ImageIO.read(iStream);
    }
}

