/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.zip;

import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.io.InvalidCharsetException;
import coldfusion.tagext.zip.ZipFilter;
import coldfusion.tagext.zip.ZipParam;
import coldfusion.tagext.zip.ZipTag;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.File;
import java.nio.charset.Charset;

public class ZipParamTag
extends ChildTag {
    private String source;
    private String entrypath;
    private Object filter;
    private String prefix;
    private boolean recurse = true;
    private boolean recurseSet = false;
    private ZipTag parent;
    private ZipFilter zipFilter;
    private Object content;
    private String charset = null;
    private String password;
    private String encryptionAlgorithm;

    public ZipParamTag() {
        super(ZipTag.class);
    }

    protected void setAncestor(Tag ancestor) {
        this.parent = (ZipTag)ancestor;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source.trim();
    }

    public String getEntrypath() {
        return this.entrypath;
    }

    public void setEntrypath(String entrypath) {
        this.entrypath = entrypath.trim();
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
        this.recurseSet = true;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        if ((charset = charset.trim()).length() > 0) {
            try {
                Charset.forName(charset);
            }
            catch (Exception e) {
                throw new InvalidCharsetException(charset);
            }
            this.charset = charset;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm.trim();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.filter != null && this.parent.getFilter() != null) {
            throw new IllegalFilterException();
        }
        if (this.filter == null) {
            this.filter = this.parent.getFilter();
        }
        if (this.entrypath != null && this.parent.getEntrypath() != null) {
            throw new IllegalPathException();
        }
        if (this.entrypath == null) {
            this.entrypath = this.parent.getEntrypath();
        }
        this.validateSource();
        if (this.prefix == null || this.prefix.length() == 0) {
            this.prefix = this.parent.getPrefix();
        }
        if (this.prefix != null && this.prefix.length() > 0) {
            this.prefix = this.prefix.replace('\\', '/');
            if (this.prefix.charAt(this.prefix.length() - 1) != '/') {
                this.prefix = this.prefix + "/";
            }
        }
        if (!this.recurseSet) {
            this.recurse = this.parent.isRecurse();
        }
        if (this.charset == null) {
            this.charset = this.parent.getCharset();
        }
        if (this.password == null) {
            this.password = this.parent.getPassword();
        }
        if (this.encryptionAlgorithm == null) {
            this.encryptionAlgorithm = this.parent.getEncryptionAlgorithm();
        }
        this.zipFilter = new ZipFilter(this.filter, this.entrypath, this.recurse);
        this.parent.addZipParams(new ZipParam(this.source, this.entrypath, this.prefix, this.zipFilter, this.content, this.charset, this.password, this.encryptionAlgorithm));
        return 0;
    }

    private void validateSource() {
        if (!this.parent.getAction().equalsIgnoreCase("zip")) {
            return;
        }
        if (this.source == null || this.source.length() == 0) {
            if (this.content == null) {
                if (this.parent.getSource() == null || this.parent.getSource().length() == 0) {
                    throw new NoSourceSpecifiedException();
                }
                this.source = this.parent.getSource();
            }
        } else {
            if (this.content != null) {
                throw new IllegalStateException();
            }
            if (this.parent.getSource() != null) {
                if (new File(this.source).isAbsolute()) {
                    throw new IllegalSourceException();
                }
                File srcFile = VFSFileFactory.getFileObject((String)this.parent.getSource(), (String)this.source);
                if (srcFile.isDirectory()) {
                    this.prefix = this.prefix == null ? this.source : this.prefix + "/" + this.source;
                } else if (this.entrypath != null) {
                    this.entrypath = this.source;
                }
                this.source = srcFile.getAbsolutePath();
            }
            if (!VFSFileFactory.getFileObject((String)this.source).exists()) {
                throw new ZipTag.InvalidSourceException(this.source);
            }
        }
    }

    public ZipFilter getZipFilter() {
        return this.zipFilter;
    }

    public void release() {
        this.source = null;
        this.entrypath = null;
        this.filter = null;
        this.prefix = null;
        this.recurse = true;
        this.recurseSet = false;
        this.parent = null;
        this.zipFilter = null;
        this.content = null;
        this.charset = null;
        this.password = null;
        this.encryptionAlgorithm = null;
        super.release();
        this.onTagEnd();
    }

    public static class IllegalFilterException
    extends ApplicationException {
    }

    public static class IllegalPathException
    extends ApplicationException {
    }

    public static class NoSourceSpecifiedException
    extends ApplicationException {
    }

    public static class IllegalSourceException
    extends ApplicationException {
    }
}

