/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.zip;

import coldfusion.runtime.OleDateTime;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import java.util.zip.ZipEntry;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipEntryTable
extends QueryTable {
    private boolean listNamesOnly;

    public ZipEntryTable(boolean listNamesOnly) {
        this.listNamesOnly = listNamesOnly;
        this.meta = new ZipEntryMetaData(listNamesOnly);
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
    }

    public void addEntry(ZipEntry entry) {
        int numCol = this.listNamesOnly ? 1 : 8;
        Object[] col_data = new Object[numCol];
        col_data[0] = entry.getName();
        if (!this.listNamesOnly) {
            String dirPath = entry.getName();
            int indexOfSlash = dirPath.lastIndexOf(47);
            dirPath = indexOfSlash != -1 ? (indexOfSlash != dirPath.length() - 1 ? dirPath.substring(0, indexOfSlash) : "") : "";
            col_data[1] = dirPath;
            col_data[2] = new Long(entry.getSize());
            col_data[3] = new Long(entry.getCompressedSize());
            col_data[4] = entry.isDirectory() ? "Directory" : "File";
            col_data[5] = new OleDateTime(entry.getTime());
            col_data[6] = entry.getComment();
            col_data[7] = new Long(entry.getCrc());
        }
        this.addRow(col_data);
    }

    public void addEntry(FileHeader entry) {
        int numCol = this.listNamesOnly ? 1 : 9;
        Object[] col_data = new Object[numCol];
        col_data[0] = entry.getFileName();
        if (!this.listNamesOnly) {
            String dirPath = entry.getFileName();
            int indexOfSlash = dirPath.lastIndexOf(47);
            dirPath = indexOfSlash != -1 ? (indexOfSlash != dirPath.length() - 1 ? dirPath.substring(0, indexOfSlash) : "") : "";
            col_data[1] = dirPath;
            col_data[2] = new Long(entry.getUncompressedSize());
            col_data[3] = new Long(entry.getCompressedSize());
            col_data[4] = entry.isDirectory() ? "Directory" : "File";
            col_data[5] = new OleDateTime(Zip4jUtil.dosToJavaTme((int)entry.getLastModFileTime()));
            col_data[6] = entry.getFileComment().trim();
            col_data[7] = new Long(entry.getCrc32());
            int encMethod = entry.getEncryptionMethod();
            String encryptionAlgorithm = "NA";
            if (entry.isEncrypted()) {
                encryptionAlgorithm = encMethod == 99 ? "AES" : "Standard";
            }
            col_data[8] = encryptionAlgorithm;
        }
        this.addRow(col_data);
    }

    static class ZipEntryMetaData
    extends QueryTableMetaData {
        public ZipEntryMetaData(boolean listNamesOnly) {
            this.column_count = listNamesOnly ? 1 : 9;
            this.column_label = new String[this.column_count];
            this.column_label[0] = "Name";
            if (!listNamesOnly) {
                this.column_label[1] = "Directory";
                this.column_label[2] = "Size";
                this.column_label[3] = "CompressedSize";
                this.column_label[4] = "Type";
                this.column_label[5] = "DateLastModified";
                this.column_label[6] = "Comment";
                this.column_label[7] = "CRC";
                this.column_label[8] = "EncryptionAlgorithm";
            }
            this.column_type = new int[this.column_count];
            this.column_type[0] = 12;
            if (!listNamesOnly) {
                this.column_type[1] = 12;
                this.column_type[2] = -5;
                this.column_type[3] = -5;
                this.column_type[4] = 12;
                this.column_type[5] = 91;
                this.column_type[6] = 12;
                this.column_type[7] = -5;
                this.column_type[8] = 12;
            }
            this.column_case = new boolean[this.column_count];
            for (int i = 0; i < this.column_count; ++i) {
                this.column_case[i] = false;
            }
            this.column_type_names = new String[this.column_count];
            this.column_type_names[0] = "VARCHAR";
            if (!listNamesOnly) {
                this.column_type_names[1] = "VARCHAR";
                this.column_type_names[2] = "BIGINT";
                this.column_type_names[3] = "BIGINT";
                this.column_type_names[4] = "VARCHAR";
                this.column_type_names[5] = "DATE";
                this.column_type_names[6] = "VARCHAR";
                this.column_type_names[7] = "BIGINT";
                this.column_type_names[8] = "VARCHAR";
            }
        }

        public boolean isCaseSensitive(int column) {
            return false;
        }
    }
}

