/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;

public class Chat {
    private static String prefix = StringUtils.randomString(5);
    private static boolean filteredOnThreadID = true;
    private static long id = 0L;
    private XMPPConnection connection;
    private String threadID;
    private String participant;
    private PacketFilter messageFilter;
    private PacketCollector messageCollector;

    private static synchronized String nextID() {
        return prefix + Long.toString(id++);
    }

    public Chat(XMPPConnection connection, String participant) {
        this(connection, participant, Chat.nextID());
        if (!filteredOnThreadID) {
            this.threadID = null;
        }
    }

    public Chat(XMPPConnection connection, String participant, String threadID) {
        this.connection = connection;
        this.participant = participant;
        this.threadID = threadID;
        this.messageFilter = filteredOnThreadID ? new ThreadFilter(threadID) : new OrFilter(new AndFilter(new MessageTypeFilter(Message.Type.CHAT), new FromContainsFilter(participant)), new ThreadFilter(threadID));
        this.messageCollector = connection.createPacketCollector(this.messageFilter);
    }

    public static boolean isFilteredOnThreadID() {
        return filteredOnThreadID;
    }

    public static void setFilteredOnThreadID(boolean value) {
        filteredOnThreadID = value;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void sendMessage(String text) throws XMPPException {
        Message message = this.createMessage();
        message.setBody(text);
        this.connection.sendPacket(message);
    }

    public Message createMessage() {
        Message message = new Message(this.participant, Message.Type.CHAT);
        message.setThread(this.threadID);
        return message;
    }

    public void sendMessage(Message message) throws XMPPException {
        message.setTo(this.participant);
        message.setType(Message.Type.CHAT);
        message.setThread(this.threadID);
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public void addMessageListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.messageFilter);
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.messageCollector != null) {
                this.messageCollector.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

