/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.runtime.SOAPFunc;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.rpc.ResponseHeader;
import coldfusion.xml.rpc.ResponseHeaders;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CFRPCMessageReceiver
extends RPCMessageReceiver {
    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        super.invokeBusinessLogic(inMessage, outMessage);
        ResponseHeaders instance = ResponseHeaders.getInstance();
        try {
            List responseHeaders = instance.getResponseHeaders();
            if (null != responseHeaders && responseHeaders.size() > 0) {
                SOAPEnvelope envelope = outMessage.getEnvelope();
                SOAPHeader header = envelope.getHeader();
                for (ResponseHeader responseHeader : responseHeaders) {
                    Object headerValue;
                    OMNamespace namespace = header.findNamespace(responseHeader.getHeaderNamespace(), null);
                    if (null == namespace) {
                        namespace = header.declareNamespace(responseHeader.getHeaderNamespace(), "");
                    }
                    if ((headerValue = responseHeader.getHeaderValue()) instanceof XmlNodeList) {
                        Node n = ((XmlNodeList)headerValue).getFirstNode();
                        if (n instanceof Document) {
                            n = ((Document)n).getDocumentElement();
                        }
                        if (!(n instanceof Element)) {
                            throw new SOAPFunc.XmlNotAnElementException();
                        }
                        OMElement om = XMLUtils.toOM((Element)((Element)n));
                        header.addChild((OMNode)om);
                        continue;
                    }
                    SOAPHeaderBlock headerBlock = header.addHeaderBlock(responseHeader.getHeaderName(), namespace);
                    headerBlock.setText(String.valueOf(headerValue));
                    headerBlock.setMustUnderstand(responseHeader.isMustUnderstand());
                }
            }
        }
        catch (Exception e) {
            throw new SOAPFunc.UnknownErrorException(e.toString());
        }
        finally {
            instance.destroy();
        }
    }
}

