/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.log.CFLogs;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoPageContext;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.CFCInvocationException;
import coldfusion.xml.rpc.CFComponentSkeleton;
import coldfusion.xml.rpc.SkeletonClassLoader;
import coldfusion.xml.rpc.WebServiceUtil;
import coldfusion.xml.rpc.module.CFCDeployer;
import coldfusion.xml.rpc.module.CFDeploymentFileData;
import coldfusion.xml.rpc.module.CFListingAgent;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.MissingResourceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.kernel.TransportListener;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.AxisServletListener;

public class CFAxis2Servlet
extends AxisServlet {
    private transient AxisServletListener httpListener;
    private transient AxisServletListener httpsListener;

    protected void initTransports() throws AxisFault {
        this.httpListener = this.getAxisServletListener("http");
        this.httpsListener = this.getAxisServletListener("https");
        if (this.httpListener == null && this.httpsListener == null) {
            CFLogs.WEBSERVICE_LOG.warn((Object)("No transportReceiver for " + AxisServletListener.class.getName() + " found. An instance for HTTP will be configured automatically. Please update your axis2.xml file!"));
            this.httpListener = new AxisServletListener();
            TransportInDescription transportInDescription = new TransportInDescription("http");
            transportInDescription.setReceiver((TransportListener)this.httpListener);
            this.axisConfiguration.addTransportIn(transportInDescription);
        } else if (this.httpListener != null && this.httpsListener != null && this.httpListener.getPort() == -1 && this.httpsListener.getPort() == -1) {
            CFLogs.WEBSERVICE_LOG.warn((Object)("If more than one transportReceiver for " + AxisServletListener.class.getName() + " exists, then all instances must be configured with a port number. WSDL generation will be unreliable."));
        }
        ListenerManager listenerManager = new ListenerManager();
        listenerManager.setShutdownHookRequired(false);
        listenerManager.init(this.configContext);
        listenerManager.start();
    }

    private AxisServletListener getAxisServletListener(String name) {
        TransportInDescription desc = this.axisConfiguration.getTransportIn(name);
        if (desc == null) {
            return null;
        }
        TransportListener receiver = desc.getReceiver();
        if (receiver instanceof AxisServletListener) {
            return (AxisServletListener)receiver;
        }
        return null;
    }

    protected void initGetRequestProcessors(ServletConfig config) {
        this.agent = new CFListingAgent(this.configContext);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processService(req);
        super.doPost(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processService(request);
        super.doGet(request, response);
    }

    private void processService(HttpServletRequest req) throws AxisFault {
        String serviceName = WebServiceUtil.getServiceName((String)req.getRequestURL().toString());
        this.undeployServiceIfModified(req, serviceName);
        AxisService service = this.axisConfiguration.getService(serviceName);
        if (null == service) {
            this.deployService(req);
        }
    }

    private void undeployServiceIfModified(HttpServletRequest request, String serviceName) throws AxisFault {
        try {
            String path = Utils.getServletPath((HttpServletRequest)request);
            path = path.substring(0, path.length() - 4);
            AttributeCollection metadata = (AttributeCollection)MetadataUtils.getComponentMetadata((String)path, (NeoPageContext)((NeoPageContext)request.getAttribute("coldfusion.runtime.NeoPageContext")), null);
            Class skeletonClass = (Class)metadata.get((Object)"skeleton");
            if (null == skeletonClass && null != this.axisConfiguration.getService(serviceName)) {
                this.undeployService(serviceName);
            }
        }
        catch (Throwable t) {
            throw new AxisFault(RB.getString((Object)((Object)this), (String)"CFAxis2Servlet.errorWhileUndeploying"), t);
        }
    }

    private void undeployService(String serviceName) throws AxisFault {
        AxisServiceGroup serviceGroup = this.axisConfiguration.removeServiceGroup(serviceName);
        this.configContext.removeServiceGroupContext(serviceGroup);
    }

    private void deployService(HttpServletRequest req) throws AxisFault, MissingResourceException {
        CFComponentSkeleton cfcObject = null;
        try {
            cfcObject = this.getCFCObject(req);
        }
        catch (Throwable throwable) {
            CFCInvocationException ex = CFComponentSkeleton.__createCFCInvocationException((Throwable)throwable);
            throw new AxisFault(RB.getString((Object)((Object)this), (String)"CFCHandler.skeletonError"), (Throwable)ex);
        }
        CFCDeployer deployer = new CFCDeployer();
        deployer.init(this.configContext);
        CFDeploymentFileData data = new CFDeploymentFileData((Deployer)deployer, cfcObject, req);
        data.deploy();
    }

    private CFComponentSkeleton getCFCObject(HttpServletRequest req) throws Throwable {
        String path = Utils.getServletPath((HttpServletRequest)req);
        NeoPageContext pageContext = (NeoPageContext)req.getAttribute("coldfusion.runtime.NeoPageContext");
        return SkeletonClassLoader.newInstance((String)path, (NeoPageContext)pageContext);
    }
}

